/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.movement;

import meteordevelopment.meteorclient.events.entity.player.ClipAtLedgeEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10185;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2902;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class SafeWalk
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgRender;
    private final Setting<Integer> fallDistance;
    private final Setting<Boolean> sneak;
    private final Setting<Boolean> safeSneak;
    private final Setting<Boolean> sneakSprint;
    private final Setting<Double> edgeDistance;
    private final Setting<Boolean> renderEdgeDistance;
    private final Setting<Boolean> renderPlayerBox;

    public SafeWalk() {
        super(Categories.Movement, "safe-walk", "Prevents you from walking off blocks.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgRender = this.settings.createGroup("Render");
        this.fallDistance = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("minimum-fall-distance")).description("The minimum number of blocks you are expected to fall before the module activates.")).defaultValue(1)).min(1).build());
        this.sneak = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sneak")).description("Sneak when approaching edge of block.")).defaultValue(false)).build());
        this.safeSneak = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("safe-sneak")).description("Prevent you from falling if sneak doesn't trigger correctly.")).defaultValue(true)).visible(this.sneak::get)).build());
        this.sneakSprint = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sneak-on-sprint")).description("Sneak even when sprinting at the block edge.")).defaultValue(true)).visible(this.sneak::get)).build());
        this.edgeDistance = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("edge-distance")).description("Distance offset before reaching an edge.")).defaultValue(0.3).sliderRange(0.0, 0.3).decimalPlaces(2).visible(this.sneak::get)).build());
        this.renderEdgeDistance = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render")).description("Render edge distance helper.")).defaultValue(false)).visible(this.sneak::get)).build());
        this.renderPlayerBox = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-player-box")).description("Render player box helper.")).defaultValue(false)).visible(() -> this.sneak.get() != false && this.renderEdgeDistance.get() != false)).build());
    }

    @EventHandler
    private void onClipAtLedge(ClipAtLedgeEvent event) {
        if (this.fallDistance.get() > 1) {
            class_3965 raycastResult;
            int surface = this.mc.field_1687.method_8500(this.mc.field_1724.method_24515()).method_12032(class_2902.class_2903.field_13197).method_12603(this.mc.field_1724.method_31477() & 0xF, this.mc.field_1724.method_31479() & 0xF);
            if (this.mc.field_1724.method_31478() >= surface ? this.mc.field_1724.method_31478() - surface < this.fallDistance.get() : (raycastResult = this.mc.field_1687.method_17742(new class_3959(this.mc.field_1724.method_73189(), new class_243(this.mc.field_1724.method_23317(), (double)this.mc.field_1687.method_31607(), this.mc.field_1724.method_23321()), class_3959.class_3960.field_17558, class_3959.class_242.field_36338, (class_1297)this.mc.field_1724))).method_17783() != class_239.class_240.field_1333 && (int)(this.mc.field_1724.method_23318() - (double)raycastResult.method_17777().method_10084().method_10264()) < this.fallDistance.get()) {
                return;
            }
        }
        if (this.sneak.get().booleanValue()) {
            boolean closeToEdge = false;
            boolean isSprinting = this.sneakSprint.get() == false && this.mc.field_1690.field_1867.method_1434();
            class_238 playerBox = this.mc.field_1724.method_5829();
            class_238 adjustedBox = this.getAdjustedPlayerBox(playerBox);
            if (this.mc.field_1687.method_8587((class_1297)this.mc.field_1724, adjustedBox) && this.mc.field_1724.method_24828()) {
                closeToEdge = true;
            }
            if (!isSprinting) {
                if (closeToEdge) {
                    this.mc.field_1724.field_3913.field_54155 = new class_10185(this.mc.field_1724.field_3913.field_54155.comp_3159(), this.mc.field_1724.field_3913.field_54155.comp_3160(), this.mc.field_1724.field_3913.field_54155.comp_3161(), this.mc.field_1724.field_3913.field_54155.comp_3162(), this.mc.field_1724.field_3913.field_54155.comp_3163(), true, this.mc.field_1724.field_3913.field_54155.comp_3165());
                } else if (this.safeSneak.get().booleanValue()) {
                    event.setClip(true);
                }
            }
        } else if (!this.mc.field_1724.method_5715()) {
            event.setClip(true);
        }
    }

    private class_238 getAdjustedPlayerBox(class_238 playerBox) {
        return playerBox.method_1012(0.0, (double)(-this.mc.field_1724.method_49476()), 0.0).method_1009(-this.edgeDistance.get().doubleValue(), 0.0, -this.edgeDistance.get().doubleValue());
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (this.sneak.get().booleanValue() && this.renderEdgeDistance.get().booleanValue()) {
            class_238 playerBox = this.mc.field_1724.method_5829();
            class_238 adjustedBox = this.getAdjustedPlayerBox(playerBox);
            event.renderer.box(adjustedBox, Color.BLUE, Color.RED, ShapeMode.Lines, 0);
            if (this.renderPlayerBox.get().booleanValue()) {
                event.renderer.box(playerBox, Color.BLUE, Color.GREEN, ShapeMode.Lines, 0);
            }
        }
    }
}

