/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.combat;

import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.renderer.ShapeMode;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.combat.CrystalAura;
import meteordevelopment.meteorclient.utils.entity.DamageUtils;
import meteordevelopment.meteorclient.utils.entity.EntityUtils;
import meteordevelopment.meteorclient.utils.entity.SortPriority;
import meteordevelopment.meteorclient.utils.entity.TargetUtils;
import meteordevelopment.meteorclient.utils.player.FindItemResult;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import meteordevelopment.meteorclient.utils.world.BlockIterator;
import meteordevelopment.meteorclient.utils.world.BlockUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class AnchorAura
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgPlace;
    private final SettingGroup sgBreak;
    private final SettingGroup sgPause;
    private final SettingGroup sgRender;
    private final Setting<Double> targetRange;
    private final Setting<SortPriority> targetPriority;
    private final Setting<Double> minDamage;
    private final Setting<Double> maxSelfDamage;
    private final Setting<Boolean> antiSuicide;
    private final Setting<Boolean> swapBack;
    private final Setting<Boolean> rotate;
    private final Setting<Boolean> place;
    private final Setting<Integer> placeDelay;
    private final Setting<Double> placeRange;
    private final Setting<Double> placeWallsRange;
    private final Setting<Boolean> airPlace;
    private final Setting<Integer> chargeDelay;
    private final Setting<Integer> breakDelay;
    private final Setting<Double> breakRange;
    private final Setting<Double> breakWallsRange;
    private final Setting<Boolean> pauseOnUse;
    private final Setting<Boolean> pauseOnMine;
    private final Setting<Boolean> pauseOnCA;
    private final Setting<Boolean> swing;
    private final Setting<Boolean> render;
    private final Setting<ShapeMode> shapeMode;
    private final Setting<SettingColor> sideColor;
    private final Setting<SettingColor> lineColor;
    private double bestPlaceDamage;
    private final class_2338.class_2339 bestPlacePos;
    private double bestBreakDamage;
    private final class_2338.class_2339 bestBreakPos;
    private class_2338 renderBlockPos;
    private int placeDelayLeft;
    private int chargeDelayLeft;
    private int breakDelayLeft;
    private class_1657 target;

    public AnchorAura() {
        super(Categories.Combat, "anchor-aura", "Automatically places and breaks Respawn Anchors to harm entities.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgPlace = this.settings.createGroup("Place");
        this.sgBreak = this.settings.createGroup("Break");
        this.sgPause = this.settings.createGroup("Pause");
        this.sgRender = this.settings.createGroup("Render");
        this.targetRange = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("target-range")).description("Range in which to target players.")).defaultValue(10.0).min(0.0).sliderMax(16.0).build());
        this.targetPriority = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("target-priority")).description("How to select the player to target.")).defaultValue(SortPriority.LowestHealth)).build());
        this.minDamage = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("min-damage")).description("The minimum damage to inflict on your target.")).defaultValue(7.0).min(0.0).sliderMax(36.0).build());
        this.maxSelfDamage = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("max-self-damage")).description("The maximum damage to inflict on yourself.")).defaultValue(7.0).min(0.0).sliderMax(36.0).build());
        this.antiSuicide = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("anti-suicide")).description("Will not place and break anchors if they will kill you.")).defaultValue(true)).build());
        this.swapBack = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swap-back")).description("Switches to your previous slot after using anchors.")).defaultValue(true)).build());
        this.rotate = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Rotates server-side towards the anchors being placed/broken.")).defaultValue(true)).build());
        this.place = this.sgPlace.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("place")).description("Allows Anchor Aura to place anchors.")).defaultValue(true)).build());
        this.placeDelay = this.sgPlace.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("place-delay")).description("The tick delay between placing anchors.")).defaultValue(5)).range(0, 10).visible(this.place::get)).build());
        this.placeRange = this.sgPlace.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("place-range")).description("The range at which anchors can be placed.")).defaultValue(4.0).range(0.0, 6.0).visible(this.place::get)).build());
        this.placeWallsRange = this.sgPlace.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("walls-range")).description("Range in which to place anchors when behind blocks.")).defaultValue(4.0).range(0.0, 6.0).visible(this.place::get)).build());
        this.airPlace = this.sgPlace.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("air-place")).description("Allows Anchor Aura to place anchors in the air.")).defaultValue(true)).visible(this.place::get)).build());
        this.chargeDelay = this.sgBreak.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("charge-delay")).description("The tick delay it takes to charge anchors.")).defaultValue(1)).range(0, 10).build());
        this.breakDelay = this.sgBreak.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("break-delay")).description("The tick delay it takes to break anchors.")).defaultValue(1)).range(0, 10).build());
        this.breakRange = this.sgBreak.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("break-range")).description("Range in which to break anchors.")).defaultValue(4.5).min(0.0).sliderMax(6.0).build());
        this.breakWallsRange = this.sgBreak.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("walls-range")).description("Range in which to break anchors when behind blocks.")).defaultValue(4.5).min(0.0).sliderMax(6.0).build());
        this.pauseOnUse = this.sgPause.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("pause-on-use")).description("Pauses while using an item.")).defaultValue(true)).build());
        this.pauseOnMine = this.sgPause.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("pause-on-mine")).description("Pauses while mining blocks.")).defaultValue(true)).build());
        this.pauseOnCA = this.sgPause.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("pause-on-CA")).description("Pauses while Crystal Aura is placing.")).defaultValue(true)).build());
        this.swing = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swing")).description("Whether to swing your hand client-side.")).defaultValue(true)).build());
        this.render = this.sgRender.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render")).description("Renders the block where it is placing an anchor.")).defaultValue(true)).build());
        this.shapeMode = this.sgRender.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("shape-mode")).description("How the shapes are rendered.")).defaultValue(ShapeMode.Both)).visible(this.render::get)).build());
        this.sideColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("side-color")).description("The side color for positions to be placed.")).defaultValue(new SettingColor(15, 255, 211, 41)).visible(() -> this.render.get() != false && this.shapeMode.get().sides())).build());
        this.lineColor = this.sgRender.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("line-color")).description("The line color for positions to be placed.")).defaultValue(new SettingColor(15, 255, 211)).visible(() -> this.render.get() != false && this.shapeMode.get().lines())).build());
        this.bestPlacePos = new class_2338.class_2339();
        this.bestBreakPos = new class_2338.class_2339();
    }

    @Override
    public void onActivate() {
        this.renderBlockPos = null;
        this.placeDelayLeft = this.placeDelay.get();
        this.chargeDelayLeft = 0;
        this.breakDelayLeft = 0;
        this.target = null;
    }

    @Override
    public void onDeactivate() {
        this.renderBlockPos = null;
    }

    @EventHandler
    private void onTick(TickEvent.Pre event) {
        if (this.mc.field_1687.method_27983() == class_1937.field_25180) {
            this.error("You can't blow up respawn anchors in this dimension, disabling.", new Object[0]);
            this.toggle();
            return;
        }
        if (this.shouldPause()) {
            this.renderBlockPos = null;
            return;
        }
        if (TargetUtils.isBadTarget(this.target, this.targetRange.get())) {
            this.renderBlockPos = null;
            this.target = TargetUtils.getPlayerTarget(this.targetRange.get(), this.targetPriority.get());
            if (TargetUtils.isBadTarget(this.target, this.targetRange.get())) {
                return;
            }
        }
        this.doAnchorAura();
    }

    private void doAnchorAura() {
        this.bestPlaceDamage = 0.0;
        this.bestBreakDamage = 0.0;
        int iteratorRange = (int)Math.ceil(Math.max(this.placeRange.get(), this.breakRange.get()));
        BlockIterator.register(iteratorRange, iteratorRange, (blockPos, blockState) -> {
            double wallsRange;
            boolean isPlacing = blockState.method_26204() != class_2246.field_23152;
            double baseRange = isPlacing ? this.placeRange.get() : this.breakRange.get();
            if (this.isOutOfRange((class_2338)blockPos, baseRange, wallsRange = (isPlacing ? this.placeWallsRange.get() : this.breakWallsRange.get()).doubleValue())) {
                return;
            }
            if (isPlacing) {
                if (!BlockUtils.canPlace(blockPos)) {
                    return;
                }
                if (!this.airPlace.get().booleanValue() && this.isAirPlace((class_2338)blockPos)) {
                    return;
                }
            }
            float bestDamage = isPlacing ? (float)this.bestPlaceDamage : (float)this.bestBreakDamage;
            float selfDamage = DamageUtils.anchorDamage((class_1309)this.mc.field_1724, blockPos.method_46558());
            float targetDamage = DamageUtils.anchorDamage((class_1309)this.target, blockPos.method_46558());
            if ((double)targetDamage >= this.minDamage.get() && targetDamage > bestDamage && (!this.antiSuicide.get().booleanValue() || (double)selfDamage <= this.maxSelfDamage.get()) && (!this.antiSuicide.get().booleanValue() || PlayerUtils.getTotalHealth() - selfDamage > 0.0f)) {
                if (isPlacing) {
                    this.bestPlaceDamage = targetDamage;
                    this.bestPlacePos.method_10101((class_2382)blockPos);
                } else {
                    this.bestBreakDamage = targetDamage;
                    this.bestBreakPos.method_10101((class_2382)blockPos);
                }
            }
        });
        BlockIterator.after(() -> {
            this.renderBlockPos = null;
            FindItemResult anchor = InvUtils.findInHotbar(class_1802.field_23141);
            FindItemResult glowStone = InvUtils.findInHotbar(class_1802.field_8801);
            if (this.bestBreakDamage > 0.0) {
                this.doBreak(glowStone);
            } else if (this.bestPlaceDamage > 0.0 && this.place.get().booleanValue() && anchor.found() && glowStone.found()) {
                this.doPlace(anchor);
            }
        });
    }

    private void doPlace(FindItemResult anchor) {
        this.renderBlockPos = this.bestPlacePos;
        if (this.placeDelayLeft++ < this.placeDelay.get()) {
            return;
        }
        BlockUtils.place((class_2338)this.bestPlacePos, anchor, this.rotate.get(), 50, this.swing.get(), false, this.swapBack.get());
        this.placeDelayLeft = 0;
    }

    private void doBreak(FindItemResult glowStone) {
        this.renderBlockPos = this.bestBreakPos;
        if (this.rotate.get().booleanValue()) {
            Rotations.rotate(Rotations.getYaw((class_2338)this.bestBreakPos), Rotations.getPitch((class_2338)this.bestBreakPos), 40, () -> this.doInteract(glowStone));
        } else {
            this.doInteract(glowStone);
        }
    }

    private void doInteract(FindItemResult glowStone) {
        class_2680 blockState = this.mc.field_1687.method_8320((class_2338)this.bestBreakPos);
        if (blockState.method_26204() != class_2246.field_23152) {
            return;
        }
        class_243 center = this.bestBreakPos.method_46558();
        int charges = (Integer)blockState.method_11654((class_2769)class_2741.field_23187);
        if (charges == 0 && this.chargeDelayLeft++ >= this.chargeDelay.get()) {
            if (!glowStone.found()) {
                return;
            }
            InvUtils.swap(glowStone.slot(), this.swapBack.get());
            BlockUtils.interact(new class_3965(center, BlockUtils.getDirection((class_2338)this.bestBreakPos), (class_2338)this.bestBreakPos, true), class_1268.field_5808, this.swing.get());
            this.chargeDelayLeft = 0;
            ++charges;
        }
        if (charges > 0 && this.breakDelayLeft++ >= this.breakDelay.get()) {
            FindItemResult fir = InvUtils.findInHotbar(item -> !item.method_7909().equals(class_1802.field_8801));
            if (!fir.found()) {
                return;
            }
            InvUtils.swap(fir.slot(), this.swapBack.get());
            BlockUtils.interact(new class_3965(center, BlockUtils.getDirection((class_2338)this.bestBreakPos), (class_2338)this.bestBreakPos, true), class_1268.field_5808, this.swing.get());
            this.breakDelayLeft = 0;
            this.mc.field_1687.method_8652((class_2338)this.bestBreakPos, this.mc.field_1687.method_8316((class_2338)this.bestBreakPos).method_15759(), 0);
        }
        if (this.swapBack.get().booleanValue()) {
            InvUtils.swapBack();
        }
    }

    private boolean isOutOfRange(class_2338 blockPos, double baseRange, double wallsRange) {
        class_243 pos = blockPos.method_46558();
        if (!PlayerUtils.isWithin(pos, baseRange)) {
            return true;
        }
        class_3959 raycastContext = new class_3959(this.mc.field_1724.method_33571(), pos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.mc.field_1724);
        class_3965 result = this.mc.field_1687.method_17742(raycastContext);
        if (result == null || !result.method_17777().equals((Object)blockPos)) {
            return !PlayerUtils.isWithin(pos, wallsRange);
        }
        return false;
    }

    private boolean isAirPlace(class_2338 blockPos) {
        for (class_2350 direction : class_2350.values()) {
            if (this.mc.field_1687.method_8320(blockPos.method_10093(direction)).method_45474()) continue;
            return false;
        }
        return true;
    }

    private boolean shouldPause() {
        if (this.pauseOnUse.get().booleanValue() && this.mc.field_1724.method_6115()) {
            return true;
        }
        if (this.pauseOnMine.get().booleanValue() && this.mc.field_1761.method_2923()) {
            return true;
        }
        CrystalAura CA = Modules.get().get(CrystalAura.class);
        return this.pauseOnCA.get() != false && CA.isActive() && CA.kaTimer > 0;
    }

    @EventHandler
    private void onRender(Render3DEvent event) {
        if (!this.render.get().booleanValue() || this.renderBlockPos == null) {
            return;
        }
        event.renderer.box(this.renderBlockPos, (Color)this.sideColor.get(), (Color)this.lineColor.get(), this.shapeMode.get(), 0);
    }

    @Override
    public String getInfoString() {
        return EntityUtils.getName((class_1297)this.target);
    }
}

