/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.combat;

import meteordevelopment.meteorclient.events.entity.player.AttackEntityEvent;
import meteordevelopment.meteorclient.events.entity.player.DoAttackEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.player.InvUtils;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_239;
import net.minecraft.class_3483;
import net.minecraft.class_3489;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_9274;
import net.minecraft.class_9362;

public class AttributeSwap
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgSwappingOptions;
    private final SettingGroup sgSwordEnchants;
    private final SettingGroup sgMaceEnchants;
    private final SettingGroup sgOtherEnchants;
    private final SettingGroup sgWeapon;
    private final Setting<Mode> mode;
    private final Setting<Integer> targetSlot;
    private final Setting<Boolean> swapOnMiss;
    private final Setting<Boolean> swapBack;
    private final Setting<Integer> swapBackDelay;
    private final Setting<Boolean> smartShieldBreak;
    private final Setting<Boolean> smartDurability;
    private final Setting<Boolean> swordSwapping;
    private final Setting<Boolean> maceSwapping;
    private final Setting<Boolean> otherSwapping;
    private final Setting<Boolean> enchantFireAspect;
    private final Setting<Boolean> enchantLooting;
    private final Setting<Boolean> enchantSharpness;
    private final Setting<Boolean> enchantSmite;
    private final Setting<Boolean> enchantBaneOfArthropods;
    private final Setting<Boolean> enchantSweepingEdge;
    private final Setting<Boolean> regularMace;
    private final Setting<Boolean> enchantDensity;
    private final Setting<Boolean> enchantBreach;
    private final Setting<Boolean> enchantWindBurst;
    private final Setting<Boolean> enchantImpaling;
    private final Setting<Boolean> onlyOnWeapon;
    private final Setting<Boolean> sword;
    private final Setting<Boolean> axe;
    private final Setting<Boolean> pickaxe;
    private final Setting<Boolean> shovel;
    private final Setting<Boolean> hoe;
    private final Setting<Boolean> mace;
    private final Setting<Boolean> trident;
    private int backTimer;
    private boolean awaitingBack;

    public AttributeSwap() {
        super(Categories.Combat, "attribute-swap", "Swaps to a target slot when you attack.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgSwappingOptions = this.settings.createGroup("Swapping Options");
        this.sgSwordEnchants = this.settings.createGroup("Sword Enchants");
        this.sgMaceEnchants = this.settings.createGroup("Mace Enchants");
        this.sgOtherEnchants = this.settings.createGroup("Other Enchants");
        this.sgWeapon = this.settings.createGroup("Weapon Options");
        this.mode = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("mode")).description("The mode to use.")).defaultValue(Mode.Simple)).build());
        this.targetSlot = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("target-slot")).description("Hotbar slot to swap to (1-9).")).defaultValue(1)).range(1, 9).visible(() -> this.mode.get() == Mode.Simple)).build());
        this.swapOnMiss = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swap-on-miss")).description("Whether to swap on a missed attack. Useful for quickly lunging with spears.")).defaultValue(false)).visible(() -> this.mode.get() == Mode.Simple)).build());
        this.swapBack = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("swap-back")).description("Swap back to the original slot after a delay.")).defaultValue(true)).build());
        this.swapBackDelay = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("swap-back-delay")).description("Delay in ticks before swapping back.")).defaultValue(2)).min(0).max(100).sliderRange(0, 20).visible(this.swapBack::get)).build());
        this.smartShieldBreak = this.sgSwappingOptions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shield-breaker")).description("Automatically swaps to an axe if the target is blocking.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart)).build());
        this.smartDurability = this.sgSwappingOptions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("durability-saver")).description("Swaps to a non-damageable item to save durability on the main weapon.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart)).build());
        this.swordSwapping = this.sgSwappingOptions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sword-swapping")).description("Enables smart swapping for sword enchantments.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart)).build());
        this.maceSwapping = this.sgSwappingOptions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("mace-swapping")).description("Enables smart swapping for mace enchantments.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart)).build());
        this.otherSwapping = this.sgSwappingOptions.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("other-swapping")).description("Enables smart swapping for other enchantments like Impaling.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart)).build());
        this.enchantFireAspect = this.sgSwordEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("fire-aspect")).description("Swaps to an item with Fire Aspect to set the target on fire, if target isn't already on fire")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.swordSwapping.get() != false)).build());
        this.enchantLooting = this.sgSwordEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("looting")).description("Swaps to an item with Looting for better drops or more experience. Only prefers for mobs (but fire aspect is priority)")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.swordSwapping.get() != false)).build());
        this.enchantSharpness = this.sgSwordEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sharpness")).description("Swaps to an item with Sharpness for increased damage against all entities.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.swordSwapping.get() != false)).build());
        this.enchantSmite = this.sgSwordEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("smite")).description("Swaps to an item with Smite for increased damage against undead mobs.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.swordSwapping.get() != false)).build());
        this.enchantBaneOfArthropods = this.sgSwordEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("bane-of-arthropods")).description("Swaps to an item with Bane of Arthropods for increased damage against arthropods.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.swordSwapping.get() != false)).build());
        this.enchantSweepingEdge = this.sgSwordEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sweeping-edge")).description("Swaps to an item with Sweeping Edge for increased sweeping attack damage.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.swordSwapping.get() != false)).build());
        this.regularMace = this.sgMaceEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("regular-mace")).description("Swaps to a regular Mace when falling if no better option is available.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.maceSwapping.get() != false)).build());
        this.enchantDensity = this.sgMaceEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("density")).description("Swaps to a Mace with Density to deal increased damage when falling.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.maceSwapping.get() != false)).build());
        this.enchantBreach = this.sgMaceEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("breach")).description("Swaps to a Mace with Breach to reduce the target's armor effectiveness.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.maceSwapping.get() != false)).build());
        this.enchantWindBurst = this.sgMaceEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("wind-burst")).description("Swaps to a Mace with Wind Burst to launch up when hitting while falling.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.maceSwapping.get() != false)).build());
        this.enchantImpaling = this.sgOtherEnchants.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("impaling")).description("Swaps to an item with Impaling for increased damage against aquatic mobs.")).defaultValue(true)).visible(() -> this.mode.get() == Mode.Smart && this.otherSwapping.get() != false)).build());
        this.onlyOnWeapon = this.sgWeapon.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("only-on-weapon")).description("Only swaps when holding a selected weapon in hand.")).defaultValue(false)).build());
        this.sword = this.sgWeapon.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sword")).description("Works while holding a sword.")).defaultValue(true)).visible(this.onlyOnWeapon::get)).build());
        this.axe = this.sgWeapon.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("axe")).description("Works while holding an axe.")).defaultValue(true)).visible(this.onlyOnWeapon::get)).build());
        this.pickaxe = this.sgWeapon.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("pickaxe")).description("Works while holding a pickaxe.")).defaultValue(true)).visible(this.onlyOnWeapon::get)).build());
        this.shovel = this.sgWeapon.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("shovel")).description("Works while holding a shovel.")).defaultValue(true)).visible(this.onlyOnWeapon::get)).build());
        this.hoe = this.sgWeapon.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("hoe")).description("Works while holding a hoe.")).defaultValue(true)).visible(this.onlyOnWeapon::get)).build());
        this.mace = this.sgWeapon.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("mace")).description("Works while holding a mace.")).defaultValue(true)).visible(this.onlyOnWeapon::get)).build());
        this.trident = this.sgWeapon.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("trident")).description("Works while holding a trident.")).defaultValue(true)).visible(this.onlyOnWeapon::get)).build());
    }

    @Override
    public void onDeactivate() {
        this.backTimer = 0;
        this.awaitingBack = false;
    }

    @EventHandler
    private void onAttack(DoAttackEvent event) {
        if (!this.canSwapByWeapon() || this.mode.get() == Mode.Smart || !this.swapOnMiss.get().booleanValue()) {
            return;
        }
        if (this.mc.field_1765.method_17783() == class_239.class_240.field_1332) {
            return;
        }
        this.doSwap(this.targetSlot.get() - 1);
    }

    @EventHandler
    private void onAttackEntity(AttackEntityEvent event) {
        if (!this.canSwapByWeapon() || this.mode.get() == Mode.Simple && this.swapOnMiss.get().booleanValue()) {
            return;
        }
        this.performSwap(event.entity);
    }

    private void performSwap(class_1297 target) {
        if (this.awaitingBack) {
            return;
        }
        if (this.mode.get() == Mode.Simple) {
            this.doSwap(this.targetSlot.get() - 1);
        } else {
            this.doSwap(this.getSmartSlot(target));
        }
    }

    private void doSwap(int slotIndex) {
        if (this.awaitingBack) {
            return;
        }
        if (slotIndex < 0 || slotIndex > 8) {
            return;
        }
        if (slotIndex == this.mc.field_1724.method_31548().method_67532()) {
            return;
        }
        if (!InvUtils.swap(slotIndex, this.swapBack.get())) {
            return;
        }
        this.awaitingBack = this.swapBack.get();
        if (this.awaitingBack) {
            this.backTimer = this.swapBackDelay.get();
        }
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!this.awaitingBack) {
            return;
        }
        if (this.backTimer-- > 0) {
            return;
        }
        InvUtils.swapBack();
        this.awaitingBack = false;
    }

    private boolean canSwapByWeapon() {
        if (!this.onlyOnWeapon.get().booleanValue()) {
            return true;
        }
        return InvUtils.testInMainHand(item -> this.sword.get() != false && item.method_31573(class_3489.field_42611) || this.axe.get() != false && item.method_31573(class_3489.field_42612) || this.pickaxe.get() != false && item.method_31573(class_3489.field_42614) || this.shovel.get() != false && item.method_31573(class_3489.field_42615) || this.hoe.get() != false && item.method_31573(class_3489.field_42613) || this.mace.get() != false && item.method_7909() instanceof class_9362 || this.trident.get() != false && item.method_7909() instanceof class_1835);
    }

    private int getSmartSlot(class_1297 target) {
        class_1309 living;
        class_1799 currentStack = this.mc.field_1724.method_6047();
        if (target != null && this.smartShieldBreak.get().booleanValue() && target instanceof class_1309 && (living = (class_1309)target).method_6039()) {
            if (currentStack.method_7909() instanceof class_1743) {
                return -1;
            }
            int axeSlot = InvUtils.findInHotbar(item -> item.method_7909() instanceof class_1743).slot();
            if (axeSlot != -1) {
                return axeSlot;
            }
        }
        boolean isFalling = this.mc.field_1724.field_6017 > 1.5;
        boolean durability = this.smartDurability.get();
        boolean isLiving = target instanceof class_1309;
        boolean isPlayer = target instanceof class_1657;
        boolean isOnFire = target != null && target.method_5809();
        boolean isUndead = target != null && target.method_5864().method_20210(class_3483.field_49931);
        boolean isArthropod = target != null && target.method_5864().method_20210(class_3483.field_48285);
        boolean isAquatic = target != null && target.method_5864().method_20210(class_3483.field_48284);
        boolean hasFireResistance = isLiving && (((class_1309)target).method_6059(class_1294.field_5918) || this.hasFireProtectionArmor((class_1309)target));
        double armor = isLiving ? ((class_1309)target).method_45325(class_5134.field_23724) : 0.0;
        float health = isLiving ? ((class_1309)target).method_6032() : 0.0f;
        int bestSlot = -1;
        double bestScore = this.getItemScore(currentStack, isFalling, durability, isLiving, isPlayer, isOnFire, hasFireResistance, isUndead, isArthropod, isAquatic, armor, health);
        for (int i = 0; i < 9; ++i) {
            double score;
            class_1799 stack;
            if (i == this.mc.field_1724.method_31548().method_67532() || (stack = this.mc.field_1724.method_31548().method_5438(i)).method_7960() && !durability || !((score = this.getItemScore(stack, isFalling, durability, isLiving, isPlayer, isOnFire, hasFireResistance, isUndead, isArthropod, isAquatic, armor, health)) > bestScore)) continue;
            bestScore = score;
            bestSlot = i;
        }
        return bestSlot;
    }

    private double getItemScore(class_1799 stack, boolean isFalling, boolean durability, boolean isLiving, boolean isPlayer, boolean isOnFire, boolean hasFireResistance, boolean isUndead, boolean isArthropod, boolean isAquatic, double armor, float health) {
        double score = 0.0;
        if (durability) {
            score += this.getDurabilityScore(stack);
        }
        if (stack.method_7960()) {
            return score;
        }
        return score += this.getCombatScore(stack, isFalling, isLiving, isPlayer, isOnFire, hasFireResistance, isUndead, isArthropod, isAquatic, armor, health);
    }

    private double getDurabilityScore(class_1799 stack) {
        if (!stack.method_7963()) {
            return 4.0;
        }
        int unbreaking = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9119);
        if (unbreaking > 0) {
            return (double)unbreaking * 0.05;
        }
        return 0.0;
    }

    private double getCombatScore(class_1799 stack, boolean isFalling, boolean isLiving, boolean isPlayer, boolean isOnFire, boolean hasFireResistance, boolean isUndead, boolean isArthropod, boolean isAquatic, double armor, float health) {
        double score = 0.0;
        if (this.swordSwapping.get().booleanValue()) {
            score += this.getFireAspectScore(stack, isOnFire, hasFireResistance);
            score += this.getLootingScore(stack, isPlayer, isLiving, isOnFire, health);
            score += this.getSharpnessScore(stack, isOnFire);
            score += this.getSmiteScore(stack, isUndead, isOnFire);
            score += this.getBaneOfArthropodsScore(stack, isArthropod, isOnFire);
            score += this.getSweepingEdgeScore(stack);
        }
        if (this.maceSwapping.get().booleanValue()) {
            score += this.getBreachScore(stack, isLiving, armor);
            score += this.getDensityScore(stack, isFalling);
            score += this.getWindBurstScore(stack, isFalling);
            score += this.getMaceScore(stack, isFalling);
        }
        if (this.otherSwapping.get().booleanValue()) {
            score += this.getImpalingScore(stack, isAquatic);
        }
        return score;
    }

    private double getFireAspectScore(class_1799 stack, boolean isOnFire, boolean hasFireResistance) {
        if (!this.enchantFireAspect.get().booleanValue() || isOnFire || hasFireResistance) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9124);
        return level > 0 ? 30.0 : 0.0;
    }

    private double getLootingScore(class_1799 stack, boolean isPlayer, boolean isLiving, boolean isOnFire, float health) {
        if (!this.enchantLooting.get().booleanValue() || isPlayer) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9110);
        if (level > 0) {
            boolean execute = isLiving && health < 20.0f || isOnFire;
            return level * (execute ? 10 : 5);
        }
        return 0.0;
    }

    private double getSharpnessScore(class_1799 stack, boolean isOnFire) {
        if (!this.enchantSharpness.get().booleanValue()) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9118);
        if (level > 0) {
            double baseScore = (1.0 + 0.5 * (double)(level - 1)) * 3.0;
            return isOnFire ? baseScore * 1.5 : baseScore;
        }
        return 0.0;
    }

    private double getSmiteScore(class_1799 stack, boolean isUndead, boolean isOnFire) {
        if (!this.enchantSmite.get().booleanValue() || !isUndead) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9123);
        if (level > 0) {
            double baseScore = level * 5;
            return isOnFire ? baseScore * 1.5 : baseScore;
        }
        return 0.0;
    }

    private double getBaneOfArthropodsScore(class_1799 stack, boolean isArthropod, boolean isOnFire) {
        if (!this.enchantBaneOfArthropods.get().booleanValue() || !isArthropod) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9112);
        if (level > 0) {
            double baseScore = level * 5;
            return isOnFire ? baseScore * 1.5 : baseScore;
        }
        return 0.0;
    }

    private double getSweepingEdgeScore(class_1799 stack) {
        if (!this.enchantSweepingEdge.get().booleanValue()) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9115);
        if (level > 0) {
            return level * 3;
        }
        return 0.0;
    }

    private double getImpalingScore(class_1799 stack, boolean isAquatic) {
        if (!this.enchantImpaling.get().booleanValue() || !isAquatic) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9106);
        if (level > 0) {
            return level * 5;
        }
        return 0.0;
    }

    private double getBreachScore(class_1799 stack, boolean isLiving, double armor) {
        if (!this.enchantBreach.get().booleanValue() || !isLiving || armor <= 0.0) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_50158);
        if (level > 0) {
            return (double)level * armor * 0.3;
        }
        return 0.0;
    }

    private double getDensityScore(class_1799 stack, boolean isFalling) {
        if (!this.enchantDensity.get().booleanValue() || !isFalling) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_50157);
        if (level > 0) {
            return 50.0 + (double)level * this.mc.field_1724.field_6017 * 2.0;
        }
        return 0.0;
    }

    private double getWindBurstScore(class_1799 stack, boolean isFalling) {
        if (!this.enchantWindBurst.get().booleanValue() || !isFalling) {
            return 0.0;
        }
        int level = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_50159);
        if (level > 0) {
            return level * 20;
        }
        return 0.0;
    }

    private double getMaceScore(class_1799 stack, boolean isFalling) {
        if (!this.regularMace.get().booleanValue() || !isFalling) {
            return 0.0;
        }
        if (stack.method_7909() instanceof class_9362) {
            return 40.0;
        }
        return 0.0;
    }

    private boolean hasFireProtectionArmor(class_1309 entity) {
        for (class_1304 slot : class_9274.field_49224) {
            int fireProtection;
            class_1799 stack = entity.method_6118(slot);
            if (stack.method_7960() || (fireProtection = Utils.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9095)) <= 0) continue;
            return true;
        }
        return false;
    }

    public static enum Mode {
        Simple,
        Smart;

    }
}

