/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.gui.widgets.containers;

import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.gui.renderer.GuiRenderer;
import meteordevelopment.meteorclient.gui.utils.Cell;
import meteordevelopment.meteorclient.gui.widgets.WWidget;
import meteordevelopment.meteorclient.gui.widgets.containers.WView;
import meteordevelopment.meteorclient.utils.Utils;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_312;

public abstract class WContainer
extends WWidget {
    public final List<Cell<?>> cells = new ArrayList();

    public <T extends WWidget> Cell<T> add(T widget) {
        widget.parent = this;
        widget.theme = this.theme;
        Cell<T> cell = new Cell<T>(widget).centerY();
        this.cells.add(cell);
        widget.init();
        this.invalidate();
        return cell;
    }

    public void clear() {
        if (!this.cells.isEmpty()) {
            this.cells.clear();
            this.invalidate();
        }
    }

    public void remove(Cell<?> cell) {
        if (this.cells.remove(cell)) {
            this.invalidate();
        }
    }

    @Override
    public void move(double deltaX, double deltaY) {
        super.move(deltaX, deltaY);
        for (Cell<?> cell : this.cells) {
            cell.move(deltaX, deltaY);
        }
    }

    public void moveCells(double deltaX, double deltaY) {
        for (Cell<?> cell : this.cells) {
            cell.move(deltaX, deltaY);
            class_312 mouse = MeteorClient.mc.field_1729;
            ((WWidget)cell.widget()).mouseMoved(mouse.method_1603(), mouse.method_1604(), mouse.method_1603(), mouse.method_1604());
        }
    }

    @Override
    public boolean isFocused() {
        for (Cell<?> cell : this.cells) {
            if (!((WWidget)cell.widget()).isFocused()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void calculateSize() {
        for (Cell<?> cell : this.cells) {
            ((WWidget)cell.widget()).calculateSize();
        }
        super.calculateSize();
    }

    @Override
    protected void onCalculateSize() {
        this.width = 0.0;
        this.height = 0.0;
        for (Cell<?> cell : this.cells) {
            this.width = Math.max(this.width, cell.padLeft() + ((WWidget)cell.widget()).width + cell.padRight());
            this.height = Math.max(this.height, cell.padTop() + ((WWidget)cell.widget()).height + cell.padBottom());
        }
    }

    @Override
    public void calculateWidgetPositions() {
        super.calculateWidgetPositions();
        for (Cell<?> cell : this.cells) {
            ((WWidget)cell.widget()).calculateWidgetPositions();
        }
    }

    @Override
    protected void onCalculateWidgetPositions() {
        for (Cell<?> cell : this.cells) {
            cell.x = this.x + cell.padLeft();
            cell.y = this.y + cell.padTop();
            cell.width = this.width - cell.padLeft() - cell.padRight();
            cell.height = this.height - cell.padTop() - cell.padBottom();
            cell.alignWidget();
        }
    }

    @Override
    public boolean render(GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        if (super.render(renderer, mouseX, mouseY, delta)) {
            return true;
        }
        WView view = this.getView();
        double windowHeight = Utils.getWindowHeight();
        for (Cell<?> cell : this.cells) {
            Object widget = cell.widget();
            if (((WWidget)widget).y > windowHeight) break;
            if (((WWidget)widget).y + ((WWidget)widget).height <= 0.0 || !this.shouldRenderWidget((WWidget)widget, view)) continue;
            this.renderWidget((WWidget)widget, renderer, mouseX, mouseY, delta);
        }
        return false;
    }

    protected void renderWidget(WWidget widget, GuiRenderer renderer, double mouseX, double mouseY, double delta) {
        widget.render(renderer, mouseX, mouseY, delta);
    }

    private boolean shouldRenderWidget(WWidget widget, WView view) {
        if (view == null) {
            return true;
        }
        if (!view.isWidgetInView(widget)) {
            return false;
        }
        if (widget.mouseOver && !view.mouseOver) {
            widget.mouseOver = false;
        }
        return true;
    }

    protected boolean propagateEvents(WWidget widget) {
        return true;
    }

    @Override
    public boolean mouseClicked(class_11909 click, boolean doubled) {
        try {
            for (Cell<?> cell : this.cells) {
                if (!this.propagateEvents((WWidget)cell.widget()) || !((WWidget)cell.widget()).mouseClicked(click, doubled)) continue;
                doubled = true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return super.mouseClicked(click, doubled) || doubled;
    }

    @Override
    public boolean mouseReleased(class_11909 click) {
        try {
            for (Cell<?> cell : this.cells) {
                if (!this.propagateEvents((WWidget)cell.widget()) || !((WWidget)cell.widget()).mouseReleased(click)) continue;
                return true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return super.mouseReleased(click);
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY, double lastMouseX, double lastMouseY) {
        try {
            for (Cell<?> cell : this.cells) {
                if (!this.propagateEvents((WWidget)cell.widget())) continue;
                ((WWidget)cell.widget()).mouseMoved(mouseX, mouseY, lastMouseX, lastMouseY);
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        super.mouseMoved(mouseX, mouseY, lastMouseX, lastMouseY);
    }

    @Override
    public boolean mouseScrolled(double amount) {
        try {
            for (Cell<?> cell : this.cells) {
                if (!this.propagateEvents((WWidget)cell.widget()) || !((WWidget)cell.widget()).mouseScrolled(amount)) continue;
                return true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return super.mouseScrolled(amount);
    }

    @Override
    public boolean keyPressed(class_11908 input) {
        try {
            for (Cell<?> cell : this.cells) {
                if (!this.propagateEvents((WWidget)cell.widget()) || !((WWidget)cell.widget()).keyPressed(input)) continue;
                return true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return this.onKeyPressed(input);
    }

    @Override
    public boolean keyRepeated(class_11908 input) {
        try {
            for (Cell<?> cell : this.cells) {
                if (!this.propagateEvents((WWidget)cell.widget()) || !((WWidget)cell.widget()).keyRepeated(input)) continue;
                return true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return this.onKeyRepeated(input);
    }

    @Override
    public boolean charTyped(class_11905 input) {
        try {
            for (Cell<?> cell : this.cells) {
                if (!this.propagateEvents((WWidget)cell.widget()) || !((WWidget)cell.widget()).charTyped(input)) continue;
                return true;
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
        return super.charTyped(input);
    }
}

