/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import meteordevelopment.meteorclient.events.game.GameLeftEvent;
import meteordevelopment.meteorclient.events.game.OpenScreenEvent;
import meteordevelopment.meteorclient.events.meteor.KeyEvent;
import meteordevelopment.meteorclient.events.meteor.MouseClickEvent;
import meteordevelopment.meteorclient.events.meteor.MouseScrollEvent;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.ChunkOcclusionEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.pathing.PathManagers;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.movement.GUIMove;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.input.Input;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import meteordevelopment.meteorclient.utils.player.Rotations;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1297;
import net.minecraft.class_1675;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2724;
import net.minecraft.class_2749;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_5498;
import net.minecraft.class_5892;
import net.minecraft.class_761;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class Freecam
extends Module {
    private final SettingGroup sgGeneral;
    private final SettingGroup sgPathing;
    private final Setting<Double> speed;
    private final Setting<Double> speedScrollSensitivity;
    private final Setting<Boolean> staySneaking;
    private final Setting<Boolean> toggleOnDamage;
    private final Setting<Boolean> toggleOnDeath;
    private final Setting<Boolean> toggleOnLog;
    private final Setting<Boolean> reloadChunks;
    private final Setting<Boolean> renderHands;
    private final Setting<Boolean> rotate;
    private final Setting<Boolean> staticView;
    private final Setting<Boolean> baritoneClick;
    private final Setting<Boolean> requireDoubleClick;
    public final Vector3d pos;
    public final Vector3d prevPos;
    private class_5498 perspective;
    private double speedValue;
    public float yaw;
    public float pitch;
    public float lastYaw;
    public float lastPitch;
    private double fovScale;
    private boolean bobView;
    private boolean forward;
    private boolean backward;
    private boolean right;
    private boolean left;
    private boolean up;
    private boolean down;
    private boolean isSneaking;
    private long clickTs;

    public Freecam() {
        super(Categories.Render, "freecam", "Allows the camera to move away from the player.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgPathing = this.settings.createGroup("Pathing");
        this.speed = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("speed")).description("Your speed while in freecam.")).onChanged(aDouble -> {
            this.speedValue = aDouble;
        })).defaultValue(1.0).min(0.0).build());
        this.speedScrollSensitivity = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("speed-scroll-sensitivity")).description("Allows you to change speed value using scroll wheel. 0 to disable.")).defaultValue(0.0).min(0.0).sliderMax(2.0).build());
        this.staySneaking = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("stay-sneaking")).description("If you are sneaking when you enter freecam, whether your player should remain sneaking.")).defaultValue(true)).build());
        this.toggleOnDamage = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("toggle-on-damage")).description("Disables freecam when you take damage.")).defaultValue(false)).build());
        this.toggleOnDeath = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("toggle-on-death")).description("Disables freecam when you die.")).defaultValue(false)).build());
        this.toggleOnLog = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("toggle-on-log")).description("Disables freecam when you disconnect from a server.")).defaultValue(true)).build());
        this.reloadChunks = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("reload-chunks")).description("Disables cave culling.")).defaultValue(true)).build());
        this.renderHands = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-hands")).description("Whether or not to render your hands in freecam.")).defaultValue(true)).build());
        this.rotate = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("rotate")).description("Rotates to the block or entity you are looking at.")).defaultValue(false)).build());
        this.staticView = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("static")).description("Disables settings that move the view.")).defaultValue(true)).build());
        this.baritoneClick = this.sgPathing.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("click-to-path")).description("Sets a pathfinding goal to any block/entity you click at.")).defaultValue(false)).build());
        this.requireDoubleClick = this.sgPathing.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("double-click")).description("Require two clicks to start pathing.")).defaultValue(false)).build());
        this.pos = new Vector3d();
        this.prevPos = new Vector3d();
        this.clickTs = 0L;
    }

    @Override
    public void onActivate() {
        this.fovScale = (Double)this.mc.field_1690.method_42454().method_41753();
        this.bobView = (Boolean)this.mc.field_1690.method_42448().method_41753();
        if (this.staticView.get().booleanValue()) {
            this.mc.field_1690.method_42454().method_41748((Object)0.0);
            this.mc.field_1690.method_42448().method_41748((Object)false);
        }
        this.yaw = this.mc.field_1724.method_36454();
        this.pitch = this.mc.field_1724.method_36455();
        this.perspective = this.mc.field_1690.method_31044();
        this.speedValue = this.speed.get();
        Utils.set(this.pos, this.mc.field_1773.method_19418().method_19326());
        Utils.set(this.prevPos, this.mc.field_1773.method_19418().method_19326());
        if (this.mc.field_1690.method_31044() == class_5498.field_26666) {
            this.yaw += 180.0f;
            this.pitch *= -1.0f;
        }
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
        this.isSneaking = this.mc.field_1690.field_1832.method_1434();
        this.forward = Input.isPressed(this.mc.field_1690.field_1894);
        this.backward = Input.isPressed(this.mc.field_1690.field_1881);
        this.right = Input.isPressed(this.mc.field_1690.field_1849);
        this.left = Input.isPressed(this.mc.field_1690.field_1913);
        this.up = Input.isPressed(this.mc.field_1690.field_1903);
        this.down = Input.isPressed(this.mc.field_1690.field_1832);
        this.unpress();
        if (this.reloadChunks.get().booleanValue()) {
            this.mc.field_1769.method_3279();
        }
    }

    @Override
    public void onDeactivate() {
        if (this.reloadChunks.get().booleanValue()) {
            this.mc.execute(() -> ((class_761)this.mc.field_1769).method_3279());
        }
        this.mc.field_1690.method_31043(this.perspective);
        if (this.staticView.get().booleanValue()) {
            this.mc.field_1690.method_42454().method_41748((Object)this.fovScale);
            this.mc.field_1690.method_42448().method_41748((Object)this.bobView);
        }
        this.isSneaking = false;
    }

    @EventHandler
    private void onOpenScreen(OpenScreenEvent event) {
        this.unpress();
        this.prevPos.set((Vector3dc)this.pos);
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
    }

    private void unpress() {
        this.mc.field_1690.field_1894.method_23481(false);
        this.mc.field_1690.field_1881.method_23481(false);
        this.mc.field_1690.field_1849.method_23481(false);
        this.mc.field_1690.field_1913.method_23481(false);
        this.mc.field_1690.field_1903.method_23481(false);
        this.mc.field_1690.field_1832.method_23481(false);
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (this.mc.method_1560().method_5757()) {
            this.mc.method_1560().field_5960 = true;
        }
        if (!this.perspective.method_31034()) {
            this.mc.field_1690.method_31043(class_5498.field_26664);
        }
        class_243 forward = class_243.method_1030((float)0.0f, (float)this.yaw);
        class_243 right = class_243.method_1030((float)0.0f, (float)(this.yaw + 90.0f));
        double velX = 0.0;
        double velY = 0.0;
        double velZ = 0.0;
        if (this.rotate.get().booleanValue()) {
            if (this.mc.field_1765 instanceof class_3966) {
                crossHairPos = ((class_3966)this.mc.field_1765).method_17782().method_24515();
                Rotations.rotate(Rotations.getYaw(crossHairPos), Rotations.getPitch(crossHairPos), 0, null);
            } else {
                class_243 crossHairPosition = this.mc.field_1765.method_17784();
                crossHairPos = ((class_3965)this.mc.field_1765).method_17777();
                if (!this.mc.field_1687.method_8320(crossHairPos).method_26215()) {
                    Rotations.rotate(Rotations.getYaw(crossHairPosition), Rotations.getPitch(crossHairPosition), 0, null);
                }
            }
        }
        double s = 0.5;
        if (Input.isPressed(this.mc.field_1690.field_1867)) {
            s = 1.0;
        }
        boolean a = false;
        if (this.forward) {
            velX += forward.field_1352 * s * this.speedValue;
            velZ += forward.field_1350 * s * this.speedValue;
            a = true;
        }
        if (this.backward) {
            velX -= forward.field_1352 * s * this.speedValue;
            velZ -= forward.field_1350 * s * this.speedValue;
            a = true;
        }
        boolean b = false;
        if (this.right) {
            velX += right.field_1352 * s * this.speedValue;
            velZ += right.field_1350 * s * this.speedValue;
            b = true;
        }
        if (this.left) {
            velX -= right.field_1352 * s * this.speedValue;
            velZ -= right.field_1350 * s * this.speedValue;
            b = true;
        }
        if (a && b) {
            double diagonal = 1.0 / Math.sqrt(2.0);
            velX *= diagonal;
            velZ *= diagonal;
        }
        if (this.up) {
            velY += s * this.speedValue;
        }
        if (this.down) {
            velY -= s * this.speedValue;
        }
        this.prevPos.set((Vector3dc)this.pos);
        this.pos.set(this.pos.x + velX, this.pos.y + velY, this.pos.z + velZ);
    }

    @EventHandler(priority=100)
    public void onKey(KeyEvent event) {
        if (Input.isKeyPressed(292)) {
            return;
        }
        if (this.checkGuiMove()) {
            return;
        }
        if (this.onInput(event.key(), event.action)) {
            event.cancel();
        }
    }

    @Nullable
    private class_2338 rayCastEntity(class_243 posVec, class_243 max, short maxDist) {
        class_3966 res = class_1675.method_18075((class_1297)this.mc.field_1724, (class_243)posVec, (class_243)max, (class_238)class_238.method_54784((class_2338)class_2338.method_49637((double)posVec.field_1352, (double)posVec.field_1351, (double)posVec.field_1350), (class_2338)class_2338.method_49637((double)max.field_1352, (double)max.field_1351, (double)max.field_1350)), entity -> true, (double)maxDist);
        if (res == null) {
            return null;
        }
        class_243 vec = res.method_17784();
        return class_2338.method_49637((double)vec.field_1352, (double)vec.field_1351, (double)vec.field_1350);
    }

    @Nullable
    private class_2338 rayCastBlock(class_243 posVec, class_243 max) {
        class_3959 ctx = new class_3959(posVec, max, class_3959.class_3960.field_23142, class_3959.class_242.field_1345, class_3726.method_16194());
        class_3965 res = this.mc.field_1687.method_17742(ctx);
        if (res.method_17783() == class_239.class_240.field_1333) {
            return null;
        }
        return res.method_17777().method_10081(res.method_17780().method_62675());
    }

    private void setGoal() {
        short maxDist;
        class_243 lookVec;
        class_243 max;
        long prevClick = this.clickTs;
        this.clickTs = System.currentTimeMillis();
        if (this.requireDoubleClick.get().booleanValue() && this.clickTs - prevClick > 500L) {
            return;
        }
        class_4184 cam = this.mc.field_1773.method_19418();
        class_243 posVec = cam.method_19326();
        class_2338 pos = this.rayCastEntity(posVec, max = posVec.method_1019((lookVec = class_243.method_1030((float)cam.method_19329(), (float)cam.method_19330())).method_1021((double)(maxDist = 256))), maxDist);
        if (pos == null) {
            pos = this.rayCastBlock(posVec, max);
        }
        if (pos == null) {
            return;
        }
        PathManagers.get().moveTo(pos);
    }

    @EventHandler(priority=100)
    private void onMouseClick(MouseClickEvent event) {
        if (this.checkGuiMove()) {
            return;
        }
        if (this.baritoneClick.get().booleanValue() && event.action == KeyAction.Press && this.mc.field_1690.field_1886.method_1433(event.click)) {
            this.setGoal();
        }
        if (this.onInput(event.button(), event.action)) {
            event.cancel();
        }
    }

    private boolean onInput(int key, KeyAction action) {
        if (Input.getKey(this.mc.field_1690.field_1894) == key) {
            this.forward = action != KeyAction.Release;
            this.mc.field_1690.field_1894.method_23481(false);
        } else if (Input.getKey(this.mc.field_1690.field_1881) == key) {
            this.backward = action != KeyAction.Release;
            this.mc.field_1690.field_1881.method_23481(false);
        } else if (Input.getKey(this.mc.field_1690.field_1849) == key) {
            this.right = action != KeyAction.Release;
            this.mc.field_1690.field_1849.method_23481(false);
        } else if (Input.getKey(this.mc.field_1690.field_1913) == key) {
            this.left = action != KeyAction.Release;
            this.mc.field_1690.field_1913.method_23481(false);
        } else if (Input.getKey(this.mc.field_1690.field_1903) == key) {
            this.up = action != KeyAction.Release;
            this.mc.field_1690.field_1903.method_23481(false);
        } else if (Input.getKey(this.mc.field_1690.field_1832) == key) {
            this.down = action != KeyAction.Release;
            this.mc.field_1690.field_1832.method_23481(false);
        } else {
            return false;
        }
        return true;
    }

    @EventHandler(priority=-100)
    private void onMouseScroll(MouseScrollEvent event) {
        if (this.speedScrollSensitivity.get() > 0.0 && this.mc.field_1755 == null) {
            this.speedValue += event.value * 0.25 * (this.speedScrollSensitivity.get() * this.speedValue);
            if (this.speedValue < 0.1) {
                this.speedValue = 0.1;
            }
            event.cancel();
        }
    }

    @EventHandler
    private void onChunkOcclusion(ChunkOcclusionEvent event) {
        event.cancel();
    }

    @EventHandler
    private void onGameLeft(GameLeftEvent event) {
        if (!this.toggleOnLog.get().booleanValue()) {
            return;
        }
        this.toggle();
    }

    @EventHandler
    private void onPacketReceive(PacketEvent.Receive event) {
        class_2596<?> class_25962 = event.packet;
        if (class_25962 instanceof class_5892) {
            class_5892 packet = (class_5892)class_25962;
            class_1297 entity = this.mc.field_1687.method_8469(packet.comp_2275());
            if (entity == this.mc.field_1724 && this.toggleOnDeath.get().booleanValue()) {
                this.toggle();
                this.info("Toggled off because you died.", new Object[0]);
            }
        } else {
            class_25962 = event.packet;
            if (class_25962 instanceof class_2749) {
                class_2749 packet = (class_2749)class_25962;
                if (this.mc.field_1724.method_6032() - packet.method_11833() > 0.0f && this.toggleOnDamage.get().booleanValue()) {
                    this.toggle();
                    this.info("Toggled off because you took damage.", new Object[0]);
                }
            } else if (event.packet instanceof class_2724 && this.isActive()) {
                this.toggle();
                this.info("Toggled off because you changed dimensions.", new Object[0]);
            }
        }
    }

    private boolean checkGuiMove() {
        GUIMove guiMove = Modules.get().get(GUIMove.class);
        if (this.mc.field_1755 != null && !guiMove.isActive()) {
            return true;
        }
        return this.mc.field_1755 != null && guiMove.isActive() && guiMove.skip();
    }

    public void changeLookDirection(double deltaX, double deltaY) {
        this.lastYaw = this.yaw;
        this.lastPitch = this.pitch;
        this.yaw += (float)deltaX;
        this.pitch += (float)deltaY;
        this.pitch = class_3532.method_15363((float)this.pitch, (float)-90.0f, (float)90.0f);
    }

    public boolean renderHands() {
        return !this.isActive() || this.renderHands.get() != false;
    }

    public boolean staySneaking() {
        return this.isActive() && !this.mc.field_1724.method_31549().field_7479 && this.staySneaking.get() != false && this.isSneaking;
    }

    public double getX(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevPos.x, (double)this.pos.x);
    }

    public double getY(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevPos.y, (double)this.pos.y);
    }

    public double getZ(float tickDelta) {
        return class_3532.method_16436((double)tickDelta, (double)this.prevPos.z, (double)this.pos.z);
    }

    public double getYaw(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastYaw, (float)this.yaw);
    }

    public double getPitch(float tickDelta) {
        return class_3532.method_16439((float)tickDelta, (float)this.lastPitch, (float)this.pitch);
    }
}

