/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.ToIntFunction;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.commands.arguments.RegistryEntryReferenceArgumentType;
import meteordevelopment.meteorclient.utils.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_490;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class EnchantCommand
extends Command {
    private static final SimpleCommandExceptionType NOT_IN_CREATIVE = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You must be in creative mode to use this."));
    private static final SimpleCommandExceptionType NOT_HOLDING_ITEM = new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"You need to hold some item to enchant."));

    public EnchantCommand() {
        super("enchant", "Enchants the item in your hand. REQUIRES Creative mode.", new String[0]);
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(EnchantCommand.literal("one").then(((RequiredArgumentBuilder)EnchantCommand.argument("enchantment", RegistryEntryReferenceArgumentType.enchantment()).then(EnchantCommand.literal("level").then(EnchantCommand.argument("level", IntegerArgumentType.integer()).executes(context -> {
            this.one((CommandContext<class_2172>)context, enchantment -> (Integer)context.getArgument("level", Integer.class));
            return 1;
        })))).then(EnchantCommand.literal("max").executes(context -> {
            this.one((CommandContext<class_2172>)context, class_1887::method_8183);
            return 1;
        }))));
        builder.then(((LiteralArgumentBuilder)EnchantCommand.literal("all_possible").then(EnchantCommand.literal("level").then(EnchantCommand.argument("level", IntegerArgumentType.integer()).executes(context -> {
            this.all(true, enchantment -> (Integer)context.getArgument("level", Integer.class));
            return 1;
        })))).then(EnchantCommand.literal("max").executes(context -> {
            this.all(true, class_1887::method_8183);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)EnchantCommand.literal("all").then(EnchantCommand.literal("level").then(EnchantCommand.argument("level", IntegerArgumentType.integer()).executes(context -> {
            this.all(false, enchantment -> (Integer)context.getArgument("level", Integer.class));
            return 1;
        })))).then(EnchantCommand.literal("max").executes(context -> {
            this.all(false, class_1887::method_8183);
            return 1;
        })));
        builder.then(EnchantCommand.literal("clear").executes(context -> {
            class_1799 itemStack = this.tryGetItemStack();
            Utils.clearEnchantments(itemStack);
            this.syncItem();
            return 1;
        }));
        builder.then(EnchantCommand.literal("remove").then(EnchantCommand.argument("enchantment", RegistryEntryReferenceArgumentType.enchantment()).executes(context -> {
            class_1799 itemStack = this.tryGetItemStack();
            class_6880.class_6883<class_1887> enchantment = RegistryEntryReferenceArgumentType.getEnchantment(context, "enchantment");
            Utils.removeEnchantment(itemStack, (class_1887)enchantment.comp_349());
            this.syncItem();
            return 1;
        })));
    }

    private void one(CommandContext<class_2172> context, ToIntFunction<class_1887> level) throws CommandSyntaxException {
        class_1799 itemStack = this.tryGetItemStack();
        class_6880.class_6883<class_1887> enchantment = RegistryEntryReferenceArgumentType.getEnchantment(context, "enchantment");
        Utils.addEnchantment(itemStack, enchantment, level.applyAsInt((class_1887)enchantment.comp_349()));
        this.syncItem();
    }

    private void all(boolean onlyPossible, ToIntFunction<class_1887> level) throws CommandSyntaxException {
        class_1799 itemStack = this.tryGetItemStack();
        mc.method_1562().method_29091().method_46759(class_7924.field_41265).ifPresent(registry -> registry.method_42017().forEach(enchantment -> {
            if (!onlyPossible || ((class_1887)enchantment.comp_349()).method_8192(itemStack)) {
                Utils.addEnchantment(itemStack, (class_6880<class_1887>)enchantment, level.applyAsInt((class_1887)enchantment.comp_349()));
            }
        }));
        this.syncItem();
    }

    private void syncItem() {
        mc.method_1507((class_437)new class_490((class_1657)EnchantCommand.mc.field_1724));
        mc.method_1507(null);
    }

    private class_1799 tryGetItemStack() throws CommandSyntaxException {
        if (!EnchantCommand.mc.field_1724.method_7337()) {
            throw NOT_IN_CREATIVE.create();
        }
        class_1799 itemStack = this.getItemStack();
        if (itemStack == null) {
            throw NOT_HOLDING_ITEM.create();
        }
        return itemStack;
    }

    private class_1799 getItemStack() {
        class_1799 itemStack = EnchantCommand.mc.field_1724.method_6047();
        if (itemStack == null) {
            itemStack = EnchantCommand.mc.field_1724.method_6079();
        }
        return itemStack.method_7960() ? null : itemStack;
    }
}

