/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.hud.elements;

import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.renderer.text.TextRenderer;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.ColorSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.hud.Hud;
import meteordevelopment.meteorclient.systems.hud.HudElement;
import meteordevelopment.meteorclient.systems.hud.HudElementInfo;
import meteordevelopment.meteorclient.systems.hud.HudRenderer;
import meteordevelopment.meteorclient.utils.render.color.SettingColor;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

public class ArmorHud
extends HudElement {
    public static final HudElementInfo<ArmorHud> INFO = new HudElementInfo<ArmorHud>(Hud.GROUP, "armor", "Displays your armor.", ArmorHud::new);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgDurability;
    private final SettingGroup sgScale;
    private final SettingGroup sgBackground;
    private final Setting<Orientation> orientation;
    private final Setting<Boolean> flipOrder;
    private final Setting<Boolean> showEmpty;
    private final Setting<Durability> durability;
    private final Setting<SettingColor> durabilityColor;
    private final Setting<Boolean> durabilityShadow;
    private final Setting<Boolean> customScale;
    private final Setting<Double> scale;
    private final Setting<Boolean> background;
    private final Setting<SettingColor> backgroundColor;

    public ArmorHud() {
        super(INFO);
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgDurability = this.settings.createGroup("Durability");
        this.sgScale = this.settings.createGroup("Scale");
        this.sgBackground = this.settings.createGroup("Background");
        this.orientation = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("orientation")).description("How to display armor.")).defaultValue(Orientation.Horizontal)).onChanged(val -> this.calculateSize())).build());
        this.flipOrder = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("flip-order")).description("Flips the order of armor items.")).defaultValue(true)).build());
        this.showEmpty = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("show-empty")).description("Renders barrier icons for empty slots.")).defaultValue(false)).build());
        this.durability = this.sgDurability.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("durability")).description("How to display armor durability.")).defaultValue(Durability.Bar)).onChanged(durability1 -> this.calculateSize())).build());
        this.durabilityColor = this.sgDurability.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("durability-color")).description("Color of the text.")).visible(() -> this.durability.get() == Durability.Total || this.durability.get() == Durability.Percentage)).defaultValue(new SettingColor()).build());
        this.durabilityShadow = this.sgDurability.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("durability-shadow")).description("Text shadow.")).visible(() -> this.durability.get() == Durability.Total || this.durability.get() == Durability.Percentage)).defaultValue(true)).build());
        this.customScale = this.sgScale.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("custom-scale")).description("Applies a custom scale to this hud element.")).defaultValue(false)).onChanged(aBoolean -> this.calculateSize())).build());
        this.scale = this.sgScale.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("Custom scale.")).visible(this.customScale::get)).defaultValue(2.0).onChanged(aDouble -> this.calculateSize())).min(0.5).sliderRange(0.5, 3.0).build());
        this.background = this.sgBackground.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("background")).description("Displays background.")).defaultValue(false)).build());
        this.backgroundColor = this.sgBackground.add(((ColorSetting.Builder)((ColorSetting.Builder)((ColorSetting.Builder)new ColorSetting.Builder().name("background-color")).description("Color used for the background.")).visible(this.background::get)).defaultValue(new SettingColor(25, 25, 25, 50)).build());
        this.calculateSize();
    }

    private void calculateSize() {
        switch (this.orientation.get().ordinal()) {
            case 0: {
                this.setSize(72.0f * this.getScale(), 16.0f * this.getScale());
                break;
            }
            case 1: {
                this.setSize(16.0f * this.getScale(), 72.0f * this.getScale());
            }
        }
    }

    @Override
    public void render(HudRenderer renderer) {
        class_1799[] armor;
        class_1799[] class_1799Array;
        int emptySlots = 0;
        if (this.flipOrder.get().booleanValue()) {
            class_1799[] class_1799Array2 = new class_1799[4];
            class_1799Array2[0] = this.getItem(3);
            class_1799Array2[1] = this.getItem(2);
            class_1799Array2[2] = this.getItem(1);
            class_1799Array = class_1799Array2;
            class_1799Array2[3] = this.getItem(0);
        } else {
            class_1799[] class_1799Array3 = new class_1799[4];
            class_1799Array3[0] = this.getItem(0);
            class_1799Array3[1] = this.getItem(1);
            class_1799Array3[2] = this.getItem(2);
            class_1799Array = class_1799Array3;
            class_1799Array3[3] = this.getItem(3);
        }
        for (class_1799 stack : armor = class_1799Array) {
            if (!stack.method_7960()) continue;
            ++emptySlots;
        }
        if (this.background.get().booleanValue() && emptySlots < 4) {
            renderer.quad(this.x, this.y, this.getWidth(), this.getHeight(), this.backgroundColor.get());
        }
        renderer.post(() -> {
            double x = this.x;
            double y = this.y;
            for (int position = 0; position < 4; ++position) {
                double armorY;
                double armorX;
                class_1799 itemStack = armor[position];
                if (this.orientation.get() == Orientation.Vertical) {
                    armorX = x;
                    armorY = y + (double)((float)(position * 18) * this.getScale());
                } else {
                    armorX = x + (double)((float)(position * 18) * this.getScale());
                    armorY = y;
                }
                renderer.item(itemStack, (int)armorX, (int)armorY, this.getScale(), itemStack.method_7963() && this.durability.get() == Durability.Bar);
                if (!itemStack.method_7963() || this.durability.get() == Durability.Bar || this.durability.get() == Durability.None) continue;
                String message = switch (this.durability.get().ordinal()) {
                    case 2 -> Integer.toString(itemStack.method_7936() - itemStack.method_7919());
                    case 3 -> Integer.toString(Math.round((float)(itemStack.method_7936() - itemStack.method_7919()) * 100.0f / (float)itemStack.method_7936()));
                    default -> "err";
                };
                double messageWidth = renderer.textWidth(message);
                if (this.orientation.get() == Orientation.Vertical) {
                    armorX = x + (double)(8.0f * this.getScale()) - messageWidth / 2.0;
                    armorY = y + (double)((float)(18 * position) * this.getScale()) + ((double)(18.0f * this.getScale()) - renderer.textHeight());
                } else {
                    armorX = x + (double)((float)(18 * position) * this.getScale()) + (double)(8.0f * this.getScale()) - messageWidth / 2.0;
                    armorY = y + ((double)this.getHeight() - renderer.textHeight());
                }
                TextRenderer.get().render(message, armorX, armorY, this.durabilityColor.get(), this.durabilityShadow.get());
            }
        });
    }

    private class_1799 getItem(int i) {
        if (this.isInEditor()) {
            return switch (i) {
                case 3 -> class_1802.field_22027.method_7854();
                case 2 -> class_1802.field_22028.method_7854();
                case 1 -> class_1802.field_22029.method_7854();
                default -> class_1802.field_22030.method_7854();
            };
        }
        class_1799 stack = MeteorClient.mc.field_1724.method_31548().method_7372(i);
        return stack.method_7960() && this.showEmpty.get() != false ? class_1802.field_8077.method_7854() : stack;
    }

    private float getScale() {
        return this.customScale.get() != false ? this.scale.get().floatValue() : this.scale.getDefaultValue().floatValue();
    }

    public static enum Orientation {
        Horizontal,
        Vertical;

    }

    public static enum Durability {
        None,
        Bar,
        Total,
        Percentage;

    }
}

