/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.DataOutput;
import java.util.Comparator;
import java.util.List;
import meteordevelopment.meteorclient.events.game.ItemStackTooltipEvent;
import meteordevelopment.meteorclient.events.render.TooltipDataEvent;
import meteordevelopment.meteorclient.mixin.EntityAccessor;
import meteordevelopment.meteorclient.mixin.EntityBucketItemAccessor;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.KeybindSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.misc.ByteCountDataOutput;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.meteorclient.utils.player.EChestMemory;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.tooltip.BannerTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.BookTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.ContainerTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.EntityTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.MapTooltipComponent;
import meteordevelopment.meteorclient.utils.tooltip.TextTooltipComponent;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10124;
import net.minecraft.class_10132;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1745;
import net.minecraft.class_1746;
import net.minecraft.class_1767;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_5761;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9209;
import net.minecraft.class_9262;
import net.minecraft.class_9275;
import net.minecraft.class_9279;
import net.minecraft.class_9298;
import net.minecraft.class_9301;
import net.minecraft.class_9302;
import net.minecraft.class_9307;
import net.minecraft.class_9334;

public class BetterTooltips
extends Module {
    public static final Color ECHEST_COLOR = new Color(0, 50, 50);
    private final SettingGroup sgGeneral;
    private final SettingGroup sgPreviews;
    private final SettingGroup sgOther;
    private final SettingGroup sgHideFlags;
    private final Setting<DisplayWhen> displayWhen;
    private final Setting<Keybind> keybind;
    private final Setting<Boolean> middleClickOpen;
    private final Setting<Boolean> pauseInCreative;
    private final Setting<Boolean> shulkers;
    private final Setting<Boolean> shulkerCompactTooltip;
    private final Setting<Boolean> echest;
    private final Setting<Boolean> maps;
    public final Setting<Double> mapsScale;
    private final Setting<Boolean> books;
    private final Setting<Boolean> banners;
    private final Setting<Boolean> entitiesInBuckets;
    public final Setting<Boolean> byteSize;
    private final Setting<Boolean> statusEffects;
    private final Setting<Boolean> beehive;
    public final Setting<Boolean> tooltip;
    public final Setting<Boolean> additional;
    public final Setting<Boolean> armorTrim;
    public final Setting<Boolean> attributeModifiers;
    public final Setting<Boolean> canBreak;
    public final Setting<Boolean> canPlaceOn;
    public final Setting<Boolean> dye;
    public final Setting<Boolean> enchantments;
    public final Setting<Boolean> jukeboxPlayable;
    public final Setting<Boolean> unbreakable;
    private boolean updateTooltips;
    private static final class_1799[] ITEMS = new class_1799[27];

    public BetterTooltips() {
        super(Categories.Render, "better-tooltips", "Displays more useful tooltips for certain items.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.sgPreviews = this.settings.createGroup("Previews");
        this.sgOther = this.settings.createGroup("Other");
        this.sgHideFlags = this.settings.createGroup("Hide Flags");
        this.displayWhen = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("display-when")).description("When to display previews.")).defaultValue(DisplayWhen.Keybind)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.keybind = this.sgGeneral.add(((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)new KeybindSetting.Builder().name("keybind")).description("The bind for keybind mode.")).defaultValue(Keybind.fromKey(342))).visible(() -> this.displayWhen.get() == DisplayWhen.Keybind)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.middleClickOpen = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("middle-click-open")).description("Opens a GUI window with the inventory of the storage block or book when you middle click the item.")).defaultValue(true)).build());
        this.pauseInCreative = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("pause-in-creative")).description("Pauses middle click open while the player is in creative mode.")).defaultValue(true)).visible(this.middleClickOpen::get)).build());
        this.shulkers = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("containers")).description("Shows a preview of a containers when hovering over it in an inventory.")).defaultValue(true)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.shulkerCompactTooltip = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("compact-shulker-tooltip")).description("Compacts the lines of the shulker tooltip.")).defaultValue(true)).build());
        this.echest = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("echests")).description("Shows a preview of your echest when hovering over it in an inventory.")).defaultValue(true)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.maps = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("maps")).description("Shows a preview of a map when hovering over it in an inventory.")).defaultValue(true)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.mapsScale = this.sgPreviews.add(((DoubleSetting.Builder)((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("map-scale")).description("The scale of the map preview.")).defaultValue(1.0).min(0.001).sliderMax(1.0).visible(this.maps::get)).build());
        this.books = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("books")).description("Shows contents of a book when hovering over it in an inventory.")).defaultValue(true)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.banners = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("banners")).description("Shows banners' patterns when hovering over it in an inventory. Also works with shields.")).defaultValue(true)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.entitiesInBuckets = this.sgPreviews.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("entities-in-buckets")).description("Shows entities in buckets when hovering over it in an inventory.")).defaultValue(true)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.byteSize = this.sgOther.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("byte-size")).description("Displays an item's size in bytes in the tooltip.")).defaultValue(true)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.statusEffects = this.sgOther.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("status-effects")).description("Adds list of status effects to tooltips of food items.")).defaultValue(true)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.beehive = this.sgOther.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("beehive")).description("Displays information about a beehive or bee nest.")).defaultValue(true)).onChanged(value -> {
            this.updateTooltips = true;
        })).build());
        this.tooltip = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("tooltip")).description("Show the tooltip when it's hidden.")).defaultValue(false)).build());
        this.additional = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("additional")).description("Show potion effects, firework status, book author, etc when it's hidden.")).defaultValue(false)).build());
        this.armorTrim = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("armor-trim")).description("Show armor trims when it's hidden.")).defaultValue(false)).build());
        this.attributeModifiers = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("attribute-modifiers")).description("Show item modifiers when it's hidden.")).defaultValue(false)).build());
        this.canBreak = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("can-break")).description("Show \"can_break\" component when it's hidden.")).defaultValue(false)).build());
        this.canPlaceOn = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("can-place-on")).description("Show \"can_place_on\" component when it's hidden.")).defaultValue(false)).build());
        this.dye = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("dye")).description("Show dyed item tags when it's hidden.")).defaultValue(false)).build());
        this.enchantments = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("enchantments")).description("Show enchantments when it's hidden.")).defaultValue(false)).build());
        this.jukeboxPlayable = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("jukebox-playable")).description("Show if something is playable in a jukebox when it's hidden.")).defaultValue(true)).build());
        this.unbreakable = this.sgHideFlags.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("unbreakable")).description("Show \"Unbreakable\" component when it's hidden.")).defaultValue(false)).build());
        this.updateTooltips = false;
    }

    @EventHandler
    private void appendTooltip(ItemStackTooltipEvent event) {
        if (!this.tooltip.get().booleanValue() && event.list().isEmpty()) {
            this.appendPreviewTooltipText(event, false);
            return;
        }
        if (this.statusEffects.get().booleanValue()) {
            if (event.itemStack().method_7909() == class_1802.field_8766) {
                class_9298 stewEffectsComponent = (class_9298)event.itemStack().method_57824(class_9334.field_49652);
                if (stewEffectsComponent != null) {
                    for (class_9298.class_8751 effectTag : stewEffectsComponent.comp_2416()) {
                        class_1293 effect2 = new class_1293(effectTag.comp_1838(), effectTag.comp_1839(), 0);
                        event.appendStart((class_2561)this.getStatusText(effect2));
                    }
                }
            } else {
                class_10124 consumable = (class_10124)event.itemStack().method_57824(class_9334.field_53964);
                if (consumable != null) {
                    consumable.comp_3089().stream().filter(class_10132.class::isInstance).map(class_10132.class::cast).flatMap(apply -> apply.comp_3094().stream()).forEach(effect -> event.appendStart((class_2561)this.getStatusText((class_1293)effect)));
                }
            }
        }
        if (this.beehive.get().booleanValue() && (event.itemStack().method_7909() == class_1802.field_20416 || event.itemStack().method_7909() == class_1802.field_20415)) {
            List bees;
            class_9275 blockStateComponent = (class_9275)event.itemStack().method_57824(class_9334.field_49623);
            if (blockStateComponent != null) {
                String level = (String)blockStateComponent.comp_2381().get("honey_level");
                event.appendStart((class_2561)class_2561.method_43470((String)String.format("%sHoney level: %s%s%s.", class_124.field_1080, class_124.field_1054, level, class_124.field_1080)));
            }
            if ((bees = (List)event.itemStack().method_57824(class_9334.field_49624)) != null) {
                event.appendStart((class_2561)class_2561.method_43470((String)String.format("%sBees: %s%d%s.", class_124.field_1080, class_124.field_1054, bees.size(), class_124.field_1080)));
            }
        }
        if (this.byteSize.get().booleanValue()) {
            try {
                event.itemStack().method_57358((class_7225.class_7874)this.mc.field_1724.method_56673()).method_10713((DataOutput)ByteCountDataOutput.INSTANCE);
                int byteCount = ByteCountDataOutput.INSTANCE.getCount();
                ByteCountDataOutput.INSTANCE.reset();
                String count = byteCount >= 1024 ? String.format("%.2f kb", Float.valueOf((float)byteCount / 1024.0f)) : String.format("%d bytes", byteCount);
                event.appendEnd((class_2561)class_2561.method_43470((String)count).method_27692(class_124.field_1080));
            }
            catch (Exception e) {
                event.appendEnd((class_2561)class_2561.method_43470((String)"Error getting bytes.").method_27692(class_124.field_1061));
            }
        }
        this.appendPreviewTooltipText(event, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler
    private void getTooltipData(TooltipDataEvent event) {
        if (this.previewShulkers() && Utils.hasItems(event.itemStack)) {
            Utils.getItemsInContainerItem(event.itemStack, ITEMS);
            event.tooltipData = new ContainerTooltipComponent(ITEMS, Utils.getShulkerColor(event.itemStack));
            return;
        }
        if (event.itemStack.method_7909() == class_1802.field_8466 && this.previewEChest()) {
            event.tooltipData = EChestMemory.isKnown() ? new ContainerTooltipComponent((class_1799[])EChestMemory.ITEMS.toArray((Object[])new class_1799[27]), ECHEST_COLOR) : new TextTooltipComponent((class_2561)class_2561.method_43470((String)"Unknown inventory.").method_27692(class_124.field_1079));
            return;
        }
        if (event.itemStack.method_7909() == class_1802.field_8204 && this.previewMaps()) {
            class_9209 mapIdComponent = (class_9209)event.itemStack.method_57824(class_9334.field_49646);
            if (mapIdComponent == null) return;
            event.tooltipData = new MapTooltipComponent(mapIdComponent.comp_2315());
            return;
        }
        if ((event.itemStack.method_7909() == class_1802.field_8674 || event.itemStack.method_7909() == class_1802.field_8360) && this.previewBooks()) {
            class_2561 page = this.getFirstPage(event.itemStack);
            if (page == null) return;
            event.tooltipData = new BookTooltipComponent(page);
            return;
        }
        if (event.itemStack.method_7909() instanceof class_1746 && this.previewBanners()) {
            event.tooltipData = new BannerTooltipComponent(event.itemStack);
            return;
        }
        class_1792 page = event.itemStack.method_7909();
        if (page instanceof class_1745) {
            class_1745 bannerPatternItem = (class_1745)page;
            if (this.previewBanners()) {
                event.tooltipData = this.createBannerFromBannerPatternItem(bannerPatternItem);
                return;
            }
        }
        if (event.itemStack.method_7909() == class_1802.field_8255 && this.previewBanners()) {
            if (((class_9307)event.itemStack.method_57825(class_9334.field_49619, (Object)class_9307.field_49404)).comp_2428().isEmpty()) return;
            event.tooltipData = this.createBannerFromShield(event.itemStack);
            return;
        }
        page = event.itemStack.method_7909();
        if (!(page instanceof class_1785)) return;
        class_1785 bucketItem = (class_1785)page;
        if (!this.previewEntities()) return;
        class_1299<?> type = ((EntityBucketItemAccessor)bucketItem).getEntityType();
        class_1297 entity = type.method_5883((class_1937)this.mc.field_1687, class_3730.field_16459);
        if (entity == null) return;
        class_9279 nbtComponent = (class_9279)event.itemStack.method_57825(class_9334.field_49610, (Object)class_9279.field_49302);
        if (nbtComponent.method_57458()) {
            return;
        }
        ((class_5761)entity).method_35170(nbtComponent.method_57461());
        ((EntityAccessor)entity).setInWater(true);
        event.tooltipData = new EntityTooltipComponent(entity);
    }

    public void applyCompactShulkerTooltip(class_1799 shulkerItem, List<class_2561> tooltip) {
        if (shulkerItem.method_57826(class_9334.field_49626)) {
            tooltip.add((class_2561)class_2561.method_43470((String)"???????"));
        }
        if (Utils.hasItems(shulkerItem)) {
            Utils.getItemsInContainerItem(shulkerItem, ITEMS);
            Object2IntOpenHashMap counts = new Object2IntOpenHashMap();
            for (class_1799 item : ITEMS) {
                if (item.method_7960()) continue;
                int count = counts.getInt((Object)item.method_7909());
                counts.put((Object)item.method_7909(), count + item.method_7947());
            }
            counts.keySet().stream().sorted(Comparator.comparingInt(arg_0 -> BetterTooltips.lambda$applyCompactShulkerTooltip$14((Object2IntMap)counts, arg_0))).limit(5L).forEach(arg_0 -> BetterTooltips.lambda$applyCompactShulkerTooltip$15((Object2IntMap)counts, tooltip, arg_0));
            if (counts.size() > 5) {
                tooltip.add((class_2561)class_2561.method_43469((String)"container.shulkerBox.more", (Object[])new Object[]{counts.size() - 5}).method_27692(class_124.field_1056));
            }
        }
    }

    private void appendPreviewTooltipText(ItemStackTooltipEvent event, boolean spacer) {
        if (!this.isPressed() && (this.shulkers.get() != false && Utils.hasItems(event.itemStack()) || event.itemStack().method_7909() == class_1802.field_8466 && this.echest.get() != false || event.itemStack().method_7909() == class_1802.field_8204 && this.maps.get() != false || event.itemStack().method_7909() == class_1802.field_8674 && this.books.get() != false || event.itemStack().method_7909() == class_1802.field_8360 && this.books.get() != false || event.itemStack().method_7909() instanceof class_1785 && this.entitiesInBuckets.get() != false || event.itemStack().method_7909() instanceof class_1746 && this.banners.get() != false || event.itemStack().method_7909() instanceof class_1745 && this.banners.get() != false || event.itemStack().method_7909() == class_1802.field_8255 && this.banners.get().booleanValue())) {
            if (spacer) {
                event.appendEnd((class_2561)class_2561.method_43470((String)""));
            }
            event.appendEnd((class_2561)class_2561.method_43470((String)("Hold " + String.valueOf(class_124.field_1054) + String.valueOf(this.keybind) + String.valueOf(class_124.field_1070) + " to preview")));
        }
    }

    private class_5250 getStatusText(class_1293 effect) {
        class_5250 text = class_2561.method_43471((String)effect.method_5586());
        if (effect.method_5578() != 0) {
            text.method_27693(String.format(" %d (%s)", effect.method_5578() + 1, class_1292.method_5577((class_1293)effect, (float)1.0f, (float)this.mc.field_1687.method_54719().method_54748()).getString()));
        } else {
            text.method_27693(String.format(" (%s)", class_1292.method_5577((class_1293)effect, (float)1.0f, (float)this.mc.field_1687.method_54719().method_54748()).getString()));
        }
        if (((class_1291)effect.method_5579().comp_349()).method_5573()) {
            return text.method_27692(class_124.field_1078);
        }
        return text.method_27692(class_124.field_1061);
    }

    private class_2561 getFirstPage(class_1799 bookItem) {
        if (bookItem.method_57824(class_9334.field_49653) != null) {
            List pages = ((class_9301)bookItem.method_57824(class_9334.field_49653)).comp_2422();
            if (pages.isEmpty()) {
                return null;
            }
            return class_2561.method_43470((String)((String)((class_9262)pages.getFirst()).method_57140(false)));
        }
        if (bookItem.method_57824(class_9334.field_49606) != null) {
            List pages = ((class_9302)bookItem.method_57824(class_9334.field_49606)).comp_2422();
            if (pages.isEmpty()) {
                return null;
            }
            return (class_2561)((class_9262)pages.getFirst()).method_57140(false);
        }
        return null;
    }

    private BannerTooltipComponent createBannerFromBannerPatternItem(class_1745 item) {
        class_9307 component = new class_9307.class_3750().method_16376(this.mc.field_1724.method_56673().method_30530(class_7924.field_41252).method_46735(item.method_7704()).method_40240(0), class_1767.field_7952).method_57573();
        return new BannerTooltipComponent(class_1767.field_7944, component);
    }

    private BannerTooltipComponent createBannerFromShield(class_1799 shieldItem) {
        class_1767 dyeColor2 = (class_1767)shieldItem.method_57825(class_9334.field_49620, (Object)class_1767.field_7952);
        class_9307 bannerPatternsComponent = (class_9307)shieldItem.method_57825(class_9334.field_49619, (Object)class_9307.field_49404);
        return new BannerTooltipComponent(dyeColor2, bannerPatternsComponent);
    }

    public boolean middleClickOpen() {
        return this.isActive() && this.middleClickOpen.get() != false && (this.pauseInCreative.get() == false || !this.mc.field_1724.method_56992());
    }

    public boolean previewShulkers() {
        return this.isActive() && this.isPressed() && this.shulkers.get() != false;
    }

    public boolean shulkerCompactTooltip() {
        return this.isActive() && this.shulkerCompactTooltip.get() != false;
    }

    private boolean previewEChest() {
        return this.isPressed() && this.echest.get() != false;
    }

    private boolean previewMaps() {
        return this.isPressed() && this.maps.get() != false;
    }

    private boolean previewBooks() {
        return this.isPressed() && this.books.get() != false;
    }

    private boolean previewBanners() {
        return this.isPressed() && this.banners.get() != false;
    }

    private boolean previewEntities() {
        return this.isPressed() && this.entitiesInBuckets.get() != false;
    }

    private boolean isPressed() {
        return this.keybind.get().isPressed() && this.displayWhen.get() == DisplayWhen.Keybind || this.displayWhen.get() == DisplayWhen.Always;
    }

    public boolean updateTooltips() {
        if (this.updateTooltips && this.isActive()) {
            this.updateTooltips = false;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void lambda$applyCompactShulkerTooltip$15(Object2IntMap counts, List tooltip, class_1792 item) {
        class_5250 mutableText = item.method_63680().method_27662();
        mutableText.method_10852((class_2561)class_2561.method_43470((String)" x").method_27693(String.valueOf(counts.getInt((Object)item))).method_27692(class_124.field_1080));
        tooltip.add(mutableText);
    }

    private static /* synthetic */ int lambda$applyCompactShulkerTooltip$14(Object2IntMap counts, class_1792 value) {
        return -counts.getInt((Object)value);
    }

    public static enum DisplayWhen {
        Keybind,
        Always;

    }
}

