/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils.misc;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Predicate;

public class UnorderedArrayList<T>
extends AbstractList<T> {
    private static final Object[] DEFAULTCAPACITY_EMPTY_ELEMENTDATA = new Object[0];
    private static final int DEFAULT_CAPACITY = 10;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private transient T[] items = DEFAULTCAPACITY_EMPTY_ELEMENTDATA;
    private int size;

    @Override
    public boolean add(T t) {
        if (this.size == this.items.length) {
            this.grow(this.size + 1);
        }
        this.items[this.size++] = t;
        ++this.modCount;
        return true;
    }

    @Override
    public T set(int index, T element) {
        T old = this.items[index];
        this.items[index] = element;
        return old;
    }

    @Override
    public T get(int index) {
        return this.items[index];
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.items[i] = null;
        }
        this.size = 0;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(this.items[i], o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        T[] elements = this.items;
        for (int i = this.size - 1; i >= 0; --i) {
            if (!Objects.equals(elements[i], o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.items[i] = null;
        this.items[i] = this.items[--this.size];
        ++this.modCount;
        return true;
    }

    @Override
    public T remove(int index) {
        T old = this.items[index];
        this.items[index] = null;
        this.items[index] = this.items[--this.size];
        ++this.modCount;
        return old;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        int preSize = this.size;
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            T item = this.items[i];
            if (filter.test(item)) continue;
            if (j < i) {
                this.items[j] = item;
            }
            ++j;
        }
        this.size = j;
        return this.size != preSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.items.length && (this.items != DEFAULTCAPACITY_EMPTY_ELEMENTDATA || minCapacity > 10)) {
            ++this.modCount;
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) {
        this.items = Arrays.copyOf(this.items, this.newCapacity(minCapacity));
    }

    private int newCapacity(int minCapacity) {
        int oldCapacity = this.items.length;
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        if (newCapacity - minCapacity <= 0) {
            if (this.items == DEFAULTCAPACITY_EMPTY_ELEMENTDATA) {
                return Math.max(10, minCapacity);
            }
            if (minCapacity < 0) {
                throw new OutOfMemoryError();
            }
            return minCapacity;
        }
        return newCapacity - 0x7FFFFFF7 <= 0 ? newCapacity : UnorderedArrayList.hugeCapacity(minCapacity);
    }

    private static int hugeCapacity(int minCapacity) {
        if (minCapacity < 0) {
            throw new OutOfMemoryError();
        }
        return minCapacity > 0x7FFFFFF7 ? Integer.MAX_VALUE : 0x7FFFFFF7;
    }
}

