/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.commands.arguments.WaypointArgumentType;
import meteordevelopment.meteorclient.systems.waypoints.Waypoint;
import meteordevelopment.meteorclient.systems.waypoints.Waypoints;
import meteordevelopment.meteorclient.utils.player.PlayerUtils;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_2338;

public class WaypointCommand
extends Command {
    public WaypointCommand() {
        super("waypoint", "Manages waypoints.", "wp");
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.then(WaypointCommand.literal("list").executes(context -> {
            if (Waypoints.get().isEmpty()) {
                this.error("No created waypoints.", new Object[0]);
            } else {
                this.info(String.valueOf(class_124.field_1068) + "Created Waypoints:", new Object[0]);
                for (Waypoint waypoint : Waypoints.get()) {
                    this.info("Name: (highlight)'%s'(default), Dimension: (highlight)%s(default), Pos: (highlight)%s(default)", new Object[]{waypoint.name.get(), waypoint.dimension.get(), this.waypointPos(waypoint)});
                }
            }
            return 1;
        }));
        builder.then(WaypointCommand.literal("get").then(WaypointCommand.argument("waypoint", WaypointArgumentType.create()).executes(context -> {
            Waypoint waypoint = WaypointArgumentType.get(context);
            this.info("Name: " + String.valueOf(class_124.field_1068) + waypoint.name.get(), new Object[0]);
            this.info("Actual Dimension: " + String.valueOf(class_124.field_1068) + String.valueOf((Object)waypoint.dimension.get()), new Object[0]);
            this.info("Position: " + String.valueOf(class_124.field_1068) + this.waypointFullPos(waypoint), new Object[0]);
            this.info("Visible: " + (waypoint.visible.get() != false ? String.valueOf(class_124.field_1060) + "True" : String.valueOf(class_124.field_1061) + "False"), new Object[0]);
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)WaypointCommand.literal("add").then(WaypointCommand.argument("pos", class_2277.method_9737()).then(WaypointCommand.argument("waypoint", StringArgumentType.greedyString()).executes(context -> this.addWaypoint((CommandContext<class_2172>)context, true))))).then(WaypointCommand.argument("waypoint", StringArgumentType.greedyString()).executes(context -> this.addWaypoint((CommandContext<class_2172>)context, false))));
        builder.then(WaypointCommand.literal("delete").then(WaypointCommand.argument("waypoint", WaypointArgumentType.create()).executes(context -> {
            Waypoint waypoint = WaypointArgumentType.get(context);
            this.info("The waypoint (highlight)'%s'(default) has been deleted.", waypoint.name.get());
            Waypoints.get().remove(waypoint);
            return 1;
        })));
        builder.then(WaypointCommand.literal("toggle").then(WaypointCommand.argument("waypoint", WaypointArgumentType.create()).executes(context -> {
            Waypoint waypoint = WaypointArgumentType.get(context);
            waypoint.visible.set(waypoint.visible.get() == false);
            Waypoints.get().save();
            return 1;
        })));
    }

    private String waypointPos(Waypoint waypoint) {
        return "X: " + waypoint.pos.get().method_10263() + " Z: " + waypoint.pos.get().method_10260();
    }

    private String waypointFullPos(Waypoint waypoint) {
        return "X: " + waypoint.pos.get().method_10263() + ", Y: " + waypoint.pos.get().method_10264() + ", Z: " + waypoint.pos.get().method_10260();
    }

    private int addWaypoint(CommandContext<class_2172> context, boolean withCoords) {
        if (WaypointCommand.mc.field_1724 == null) {
            return -1;
        }
        class_2338 pos = withCoords ? ((class_2267)context.getArgument("pos", class_2267.class)).method_9704(WaypointCommand.mc.field_1724.method_5671(mc.method_1576().method_30002())) : WaypointCommand.mc.field_1724.method_24515().method_10086(2);
        Waypoint waypoint = new Waypoint.Builder().name(StringArgumentType.getString(context, (String)"waypoint")).pos(pos).dimension(PlayerUtils.getDimension()).build();
        Waypoints.get().add(waypoint);
        this.info("Created waypoint with name: (highlight)%s(default)", waypoint.name.get());
        return 1;
    }
}

