/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.movement;

import meteordevelopment.meteorclient.events.meteor.KeyEvent;
import meteordevelopment.meteorclient.events.meteor.MouseButtonEvent;
import meteordevelopment.meteorclient.events.render.Render3DEvent;
import meteordevelopment.meteorclient.gui.WidgetScreen;
import meteordevelopment.meteorclient.mixin.CreativeInventoryScreenAccessor;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.EnumSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.Freecam;
import meteordevelopment.meteorclient.utils.misc.input.Input;
import meteordevelopment.meteorclient.utils.misc.input.KeyAction;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_304;
import net.minecraft.class_3532;
import net.minecraft.class_408;
import net.minecraft.class_463;
import net.minecraft.class_471;
import net.minecraft.class_481;
import net.minecraft.class_497;
import net.minecraft.class_498;
import net.minecraft.class_7706;

public class GUIMove
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Screens> screens;
    public final Setting<Boolean> jump;
    public final Setting<Boolean> sneak;
    public final Setting<Boolean> sprint;
    private final Setting<Boolean> arrowsRotate;
    private final Setting<Double> rotateSpeed;

    public GUIMove() {
        super(Categories.Movement, "gui-move", "Allows you to perform various actions while in GUIs.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.screens = this.sgGeneral.add(((EnumSetting.Builder)((EnumSetting.Builder)((EnumSetting.Builder)new EnumSetting.Builder().name("guis")).description("Which GUIs to move in.")).defaultValue(Screens.Inventory)).build());
        this.jump = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("jump")).description("Allows you to jump while in GUIs.")).defaultValue(true)).onChanged(aBoolean -> {
            if (this.isActive() && !aBoolean.booleanValue()) {
                this.mc.field_1690.field_1903.method_23481(false);
            }
        })).build());
        this.sneak = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sneak")).description("Allows you to sneak while in GUIs.")).defaultValue(true)).onChanged(aBoolean -> {
            if (this.isActive() && !aBoolean.booleanValue()) {
                this.mc.field_1690.field_1832.method_23481(false);
            }
        })).build());
        this.sprint = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("sprint")).description("Allows you to sprint while in GUIs.")).defaultValue(true)).onChanged(aBoolean -> {
            if (this.isActive() && !aBoolean.booleanValue()) {
                this.mc.field_1690.field_1867.method_23481(false);
            }
        })).build());
        this.arrowsRotate = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("arrows-rotate")).description("Allows you to use your arrow keys to rotate while in GUIs.")).defaultValue(true)).build());
        this.rotateSpeed = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("rotate-speed")).description("Rotation speed while in GUIs.")).defaultValue(4.0).min(0.0).build());
    }

    @Override
    public void onDeactivate() {
        this.mc.field_1690.field_1894.method_23481(false);
        this.mc.field_1690.field_1881.method_23481(false);
        this.mc.field_1690.field_1913.method_23481(false);
        this.mc.field_1690.field_1849.method_23481(false);
        if (this.jump.get().booleanValue()) {
            this.mc.field_1690.field_1903.method_23481(false);
        }
        if (this.sneak.get().booleanValue()) {
            this.mc.field_1690.field_1832.method_23481(false);
        }
        if (this.sprint.get().booleanValue()) {
            this.mc.field_1690.field_1867.method_23481(false);
        }
    }

    public boolean disableSpace() {
        return this.isActive() && this.jump.get() != false && this.mc.field_1690.field_1903.method_1427();
    }

    public boolean disableArrows() {
        return this.isActive() && this.arrowsRotate.get() != false;
    }

    private void onInput(int key, KeyAction action, boolean mouse) {
        if (this.skip()) {
            return;
        }
        if (this.screens.get() == Screens.GUI && !(this.mc.field_1755 instanceof WidgetScreen)) {
            return;
        }
        if (this.screens.get() == Screens.Inventory && this.mc.field_1755 instanceof WidgetScreen) {
            return;
        }
        this.pass(this.mc.field_1690.field_1894, key, action, mouse);
        this.pass(this.mc.field_1690.field_1881, key, action, mouse);
        this.pass(this.mc.field_1690.field_1913, key, action, mouse);
        this.pass(this.mc.field_1690.field_1849, key, action, mouse);
        if (this.jump.get().booleanValue()) {
            this.pass(this.mc.field_1690.field_1903, key, action, mouse);
        }
        if (this.sneak.get().booleanValue()) {
            this.pass(this.mc.field_1690.field_1832, key, action, mouse);
        }
        if (this.sprint.get().booleanValue()) {
            this.pass(this.mc.field_1690.field_1867, key, action, mouse);
        }
    }

    @EventHandler
    private void onKey(KeyEvent event) {
        this.onInput(event.key, event.action, false);
    }

    @EventHandler
    private void onButton(MouseButtonEvent event) {
        this.onInput(event.button, event.action, true);
    }

    @EventHandler
    private void onRender3D(Render3DEvent event) {
        if (this.skip()) {
            return;
        }
        if (this.screens.get() == Screens.GUI && !(this.mc.field_1755 instanceof WidgetScreen)) {
            return;
        }
        if (this.screens.get() == Screens.Inventory && this.mc.field_1755 instanceof WidgetScreen) {
            return;
        }
        float rotationDelta = Math.min((float)(this.rotateSpeed.get() * event.frameTime * 20.0), 100.0f);
        Freecam freecam = Modules.get().get(Freecam.class);
        if (this.arrowsRotate.get().booleanValue()) {
            if (!freecam.isActive()) {
                float yaw = this.mc.field_1724.method_36454();
                float pitch = this.mc.field_1724.method_36455();
                if (Input.isKeyPressed(263)) {
                    yaw -= rotationDelta;
                }
                if (Input.isKeyPressed(262)) {
                    yaw += rotationDelta;
                }
                if (Input.isKeyPressed(265)) {
                    pitch -= rotationDelta;
                }
                if (Input.isKeyPressed(264)) {
                    pitch += rotationDelta;
                }
                pitch = class_3532.method_15363((float)pitch, (float)-90.0f, (float)90.0f);
                this.mc.field_1724.method_36456(yaw);
                this.mc.field_1724.method_36457(pitch);
            } else {
                double dy = 0.0;
                double dx = 0.0;
                if (Input.isKeyPressed(263)) {
                    dy = -rotationDelta;
                }
                if (Input.isKeyPressed(262)) {
                    dy = rotationDelta;
                }
                if (Input.isKeyPressed(265)) {
                    dx = -rotationDelta;
                }
                if (Input.isKeyPressed(264)) {
                    dx = rotationDelta;
                }
                freecam.changeLookDirection(dy, dx);
            }
        }
    }

    private void pass(class_304 bind, int key, KeyAction action, boolean mouse) {
        if (!mouse && !bind.method_1417(key, 0)) {
            return;
        }
        if (mouse && !bind.method_1433(key)) {
            return;
        }
        if (action == KeyAction.Press) {
            bind.method_23481(true);
        }
        if (action == KeyAction.Release) {
            bind.method_23481(false);
        }
    }

    public boolean skip() {
        return this.mc.field_1755 == null || this.mc.field_1755 instanceof class_481 && CreativeInventoryScreenAccessor.getSelectedTab() == class_7706.method_47344() || this.mc.field_1755 instanceof class_408 || this.mc.field_1755 instanceof class_498 || this.mc.field_1755 instanceof class_471 || this.mc.field_1755 instanceof class_463 || this.mc.field_1755 instanceof class_497;
    }

    public static enum Screens {
        GUI,
        Inventory,
        Both;

    }
}

