/*
 * Decompiled with CFR 0.152.
 */
package org.meteordev.starscript.compiler;

import org.meteordev.starscript.Instruction;
import org.meteordev.starscript.Script;
import org.meteordev.starscript.compiler.Expr;
import org.meteordev.starscript.compiler.Parser;
import org.meteordev.starscript.compiler.Token;
import org.meteordev.starscript.value.Value;

public class Compiler
implements Expr.Visitor {
    private final Script script = new Script();
    private int blockDepth;
    private boolean constantAppend;
    private boolean variableAppend;
    private boolean getAppend;
    private boolean callAppend;

    private Compiler() {
    }

    public static Script compile(Parser.Result result) {
        Compiler compiler = new Compiler();
        for (Expr expr : result.exprs) {
            compiler.compile(expr);
        }
        compiler.script.write(Instruction.End);
        return compiler.script;
    }

    @Override
    public void visitNull(Expr.Null expr) {
        this.script.write(Instruction.Null);
    }

    @Override
    public void visitString(Expr.String expr) {
        this.script.write(this.blockDepth == 0 || this.constantAppend ? Instruction.ConstantAppend : Instruction.Constant, Value.string(expr.string));
    }

    @Override
    public void visitNumber(Expr.Number expr) {
        this.script.write(Instruction.Constant, Value.number(expr.number));
    }

    @Override
    public void visitBool(Expr.Bool expr) {
        this.script.write(expr.bool ? Instruction.True : Instruction.False);
    }

    @Override
    public void visitBlock(Expr.Block expr) {
        ++this.blockDepth;
        if (expr.getExpr() instanceof Expr.String) {
            this.constantAppend = true;
        } else if (expr.getExpr() instanceof Expr.Variable) {
            this.variableAppend = true;
        } else if (expr.getExpr() instanceof Expr.Get) {
            this.getAppend = true;
        } else if (expr.getExpr() instanceof Expr.Call) {
            this.callAppend = true;
        }
        this.compile(expr.getExpr());
        if (!(this.constantAppend || this.variableAppend || this.getAppend || this.callAppend)) {
            this.script.write(Instruction.Append);
        } else {
            this.constantAppend = false;
            this.variableAppend = false;
            this.getAppend = false;
            this.callAppend = false;
        }
        --this.blockDepth;
    }

    @Override
    public void visitGroup(Expr.Group expr) {
        this.compile(expr.getExpr());
    }

    @Override
    public void visitBinary(Expr.Binary expr) {
        this.compile(expr.getLeft());
        if (expr.op == Token.Plus && (expr.getRight() instanceof Expr.String || expr.getRight() instanceof Expr.Number)) {
            this.script.write(Instruction.AddConstant, expr.getRight() instanceof Expr.String ? Value.string(((Expr.String)expr.getRight()).string) : Value.number(((Expr.Number)expr.getRight()).number));
            return;
        }
        this.compile(expr.getRight());
        switch (expr.op) {
            case Plus: {
                this.script.write(Instruction.Add);
                break;
            }
            case Minus: {
                this.script.write(Instruction.Subtract);
                break;
            }
            case Star: {
                this.script.write(Instruction.Multiply);
                break;
            }
            case Slash: {
                this.script.write(Instruction.Divide);
                break;
            }
            case Percentage: {
                this.script.write(Instruction.Modulo);
                break;
            }
            case UpArrow: {
                this.script.write(Instruction.Power);
                break;
            }
            case EqualEqual: {
                this.script.write(Instruction.Equals);
                break;
            }
            case BangEqual: {
                this.script.write(Instruction.NotEquals);
                break;
            }
            case Greater: {
                this.script.write(Instruction.Greater);
                break;
            }
            case GreaterEqual: {
                this.script.write(Instruction.GreaterEqual);
                break;
            }
            case Less: {
                this.script.write(Instruction.Less);
                break;
            }
            case LessEqual: {
                this.script.write(Instruction.LessEqual);
            }
        }
    }

    @Override
    public void visitUnary(Expr.Unary expr) {
        this.compile(expr.getRight());
        if (expr.op == Token.Bang) {
            this.script.write(Instruction.Not);
        } else if (expr.op == Token.Minus) {
            this.script.write(Instruction.Negate);
        }
    }

    @Override
    public void visitVariable(Expr.Variable expr) {
        this.script.write(this.variableAppend ? Instruction.VariableAppend : Instruction.Variable, Value.string(expr.name));
    }

    @Override
    public void visitGet(Expr.Get expr) {
        boolean prevGetAppend = this.getAppend;
        this.getAppend = false;
        boolean variableGet = expr.getObject() instanceof Expr.Variable;
        if (!variableGet) {
            this.compile(expr.getObject());
        }
        this.getAppend = prevGetAppend;
        if (variableGet) {
            this.script.write(this.getAppend ? Instruction.VariableGetAppend : Instruction.VariableGet, Value.string(((Expr.Variable)expr.getObject()).name));
            this.script.writeConstant(Value.string(expr.name));
        } else {
            this.script.write(this.getAppend ? Instruction.GetAppend : Instruction.Get, Value.string(expr.name));
        }
    }

    @Override
    public void visitCall(Expr.Call expr) {
        boolean prevCallAppend = this.callAppend;
        this.compile(expr.getCallee());
        this.callAppend = false;
        for (int i = 0; i < expr.getArgCount(); ++i) {
            this.compile(expr.getArg(i));
        }
        this.callAppend = prevCallAppend;
        this.script.write(this.callAppend ? Instruction.CallAppend : Instruction.Call, expr.getArgCount());
    }

    @Override
    public void visitLogical(Expr.Logical expr) {
        this.compile(expr.getLeft());
        int endJump = this.script.writeJump(expr.op == Token.And ? Instruction.JumpIfFalse : Instruction.JumpIfTrue);
        this.script.write(Instruction.Pop);
        this.compile(expr.getRight());
        this.script.patchJump(endJump);
    }

    @Override
    public void visitConditional(Expr.Conditional expr) {
        this.compile(expr.getCondition());
        int falseJump = this.script.writeJump(Instruction.JumpIfFalse);
        this.script.write(Instruction.Pop);
        this.compile(expr.getTrueExpr());
        int endJump = this.script.writeJump(Instruction.Jump);
        this.script.patchJump(falseJump);
        this.script.write(Instruction.Pop);
        this.compile(expr.getFalseExpr());
        this.script.patchJump(endJump);
    }

    @Override
    public void visitSection(Expr.Section expr) {
        this.script.write(Instruction.Section, expr.index);
        this.compile(expr.getExpr());
    }

    private void compile(Expr expr) {
        if (expr != null) {
            expr.accept(this);
        }
    }
}

