/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.commands.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import joptsimple.internal.Strings;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.commands.Command;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.mixin.ClientPlayNetworkHandlerAccessor;
import meteordevelopment.meteorclient.utils.world.TickRate;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2596;
import net.minecraft.class_2639;
import net.minecraft.class_2641;
import net.minecraft.class_2805;
import net.minecraft.class_5250;
import net.minecraft.class_639;
import net.minecraft.class_642;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import org.apache.commons.lang3.StringUtils;

public class ServerCommand
extends Command {
    private static final Set<String> ANTICHEAT_LIST = Set.of("nocheatplus", "negativity", "warden", "horizon", "illegalstack", "coreprotect", "exploitsx", "vulcan", "abc", "spartan", "kauri", "anticheatreloaded", "witherac", "godseye", "matrix", "wraith", "antixrayheuristics", "grimac");
    private static final Set<String> VERSION_ALIASES = Set.of("version", "ver", "about", "bukkit:version", "bukkit:ver", "bukkit:about");
    private String alias;
    private int ticks = 0;
    private boolean tick = false;
    private final List<String> plugins = new ArrayList<String>();
    private final List<String> commandTreePlugins = new ArrayList<String>();
    private static final Random RANDOM = new Random();

    public ServerCommand() {
        super("server", "Prints server information", new String[0]);
        MeteorClient.EVENT_BUS.subscribe(this);
    }

    @Override
    public void build(LiteralArgumentBuilder<class_2172> builder) {
        builder.executes(context -> {
            this.basicInfo();
            return 1;
        });
        builder.then(ServerCommand.literal("info").executes(ctx -> {
            this.basicInfo();
            return 1;
        }));
        builder.then(ServerCommand.literal("plugins").executes(ctx -> {
            this.plugins.addAll(this.commandTreePlugins);
            if (this.alias != null) {
                mc.method_1562().method_52787((class_2596)new class_2805(RANDOM.nextInt(200), this.alias + " "));
                this.tick = true;
            } else {
                this.printPlugins();
            }
            return 1;
        }));
        builder.then(ServerCommand.literal("tps").executes(ctx -> {
            float tps = TickRate.INSTANCE.getTickRate();
            class_124 color = tps > 17.0f ? class_124.field_1060 : (tps > 12.0f ? class_124.field_1054 : class_124.field_1061);
            this.info("Current TPS: %s%.2f(default).", color, Float.valueOf(tps));
            return 1;
        }));
    }

    private void basicInfo() {
        class_5250 ipText;
        if (mc.method_1496()) {
            class_1132 server = mc.method_1576();
            this.info("Singleplayer", new Object[0]);
            if (server != null) {
                this.info("Version: %s", server.method_3827());
            }
            return;
        }
        class_642 server = mc.method_1558();
        if (server == null) {
            this.info("Couldn't obtain any server information.", new Object[0]);
            return;
        }
        String ipv4 = "";
        try {
            ipv4 = InetAddress.getByName(server.field_3761).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        if (ipv4.isEmpty()) {
            ipText = class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + server.field_3761));
            ipText.method_10862(ipText.method_10866().method_10958((class_2558)new class_2558.class_10606(server.field_3761)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Copy to clipboard"))));
        } else {
            ipText = class_2561.method_43470((String)(String.valueOf(class_124.field_1080) + server.field_3761));
            ipText.method_10862(ipText.method_10866().method_10958((class_2558)new class_2558.class_10606(server.field_3761)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Copy to clipboard"))));
            class_5250 ipv4Text = class_2561.method_43470((String)String.format("%s (%s)", class_124.field_1080, ipv4));
            ipv4Text.method_10862(ipText.method_10866().method_10958((class_2558)new class_2558.class_10606(ipv4)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"Copy to clipboard"))));
            ipText.method_10852((class_2561)ipv4Text);
        }
        this.info((class_2561)class_2561.method_43470((String)String.format("%sIP: ", class_124.field_1080)).method_10852((class_2561)ipText));
        this.info("Port: %d", class_639.method_2950((String)server.field_3761).method_2954());
        this.info("Type: %s", mc.method_1562().method_52790() != null ? mc.method_1562().method_52790() : "unknown");
        this.info("Motd: %s", server.field_3757 != null ? server.field_3757.getString() : "unknown");
        this.info("Version: %s", server.field_3760.getString());
        this.info("Protocol version: %d", server.field_3756);
        this.info("Difficulty: %s (Local: %.2f)", ServerCommand.mc.field_1687.method_8407().method_5463().getString(), Float.valueOf(ServerCommand.mc.field_1687.method_8404(ServerCommand.mc.field_1724.method_24515()).method_5457()));
        this.info("Day: %d", ServerCommand.mc.field_1687.method_8532() / 24000L);
        this.info("Permission level: %s", this.formatPerms());
    }

    public String formatPerms() {
        int p;
        for (p = 5; !ServerCommand.mc.field_1724.method_64475(p) && p > 0; --p) {
        }
        return switch (p) {
            case 0 -> "0 (No Perms)";
            case 1 -> "1 (No Perms)";
            case 2 -> "2 (Player Command Access)";
            case 3 -> "3 (Server Command Access)";
            case 4 -> "4 (Operator)";
            default -> p + " (Unknown)";
        };
    }

    private void printPlugins() {
        this.plugins.sort(String.CASE_INSENSITIVE_ORDER);
        this.plugins.replaceAll(this::formatName);
        if (!this.plugins.isEmpty()) {
            this.info("Plugins (%d): %s ", this.plugins.size(), Strings.join((String[])this.plugins.toArray(new String[0]), (String)", "));
        } else {
            this.error("No plugins found.", new Object[0]);
        }
        this.tick = false;
        this.ticks = 0;
        this.plugins.clear();
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        if (!this.tick) {
            return;
        }
        ++this.ticks;
        if (this.ticks >= 100) {
            this.printPlugins();
        }
    }

    @EventHandler
    private void onSendPacket(PacketEvent.Send event) {
        if (this.tick && event.packet instanceof class_2805) {
            event.cancel();
        }
    }

    @EventHandler
    private void onReadPacket(PacketEvent.Receive event) {
        Object handler;
        class_2641 packet;
        class_2596<?> class_25962 = event.packet;
        if (class_25962 instanceof class_2641) {
            packet = (class_2641)class_25962;
            handler = (ClientPlayNetworkHandlerAccessor)event.connection.method_10744();
            this.commandTreePlugins.clear();
            this.alias = null;
            packet.method_11403(class_7157.method_46722((class_7225.class_7874)handler.meteor$getCombinedDynamicRegistries(), (class_7699)handler.meteor$getEnabledFeatures()), ClientPlayNetworkHandlerAccessor.meteor$getCommandNodeFactory()).getChildren().forEach(node -> {
                String[] split = node.getName().split(":");
                if (split.length > 1 && !this.commandTreePlugins.contains(split[0])) {
                    this.commandTreePlugins.add(split[0]);
                }
                if (this.alias == null && VERSION_ALIASES.contains(node.getName())) {
                    this.alias = node.getName();
                }
            });
        }
        if (!this.tick) {
            return;
        }
        try {
            handler = event.packet;
            if (handler instanceof class_2639) {
                packet = (class_2639)handler;
                Suggestions matches = packet.method_11397();
                if (matches.isEmpty()) {
                    this.error("An error occurred while trying to find plugins.", new Object[0]);
                    return;
                }
                for (Suggestion suggestion : matches.getList()) {
                    String pluginName = suggestion.getText();
                    if (this.plugins.contains(pluginName.toLowerCase())) continue;
                    this.plugins.add(pluginName);
                }
                this.printPlugins();
            }
        }
        catch (Exception e) {
            this.error("An error occurred while trying to find plugins.", new Object[0]);
        }
    }

    private String formatName(String name) {
        if (ANTICHEAT_LIST.contains(name.toLowerCase())) {
            return String.format("%s%s(default)", class_124.field_1061, name);
        }
        if (StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"exploit") || StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"cheat") || StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)"illegal")) {
            return String.format("%s%s(default)", class_124.field_1061, name);
        }
        return String.format("(highlight)%s(default)", name);
    }
}

