/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.render;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import meteordevelopment.meteorclient.events.render.Render2DEvent;
import meteordevelopment.meteorclient.renderer.Renderer2D;
import meteordevelopment.meteorclient.renderer.text.TextRenderer;
import meteordevelopment.meteorclient.settings.DoubleSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.network.Http;
import meteordevelopment.meteorclient.utils.network.MeteorExecutor;
import meteordevelopment.meteorclient.utils.render.NametagUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10583;
import net.minecraft.class_10598;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

public class EntityOwner
extends Module {
    private static final Color BACKGROUND = new Color(0, 0, 0, 75);
    private static final Color TEXT = new Color(255, 255, 255);
    private final SettingGroup sgGeneral;
    private final Setting<Double> scale;
    private final Vector3d pos;
    private final Map<UUID, String> uuidToName;

    public EntityOwner() {
        super(Categories.Render, "entity-owner", "Displays the name of the player who owns the entity you're looking at.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.scale = this.sgGeneral.add(((DoubleSetting.Builder)((DoubleSetting.Builder)new DoubleSetting.Builder().name("scale")).description("The scale of the text.")).defaultValue(1.0).min(0.0).build());
        this.pos = new Vector3d();
        this.uuidToName = new HashMap<UUID, String>();
    }

    @Override
    public void onDeactivate() {
        this.uuidToName.clear();
    }

    @EventHandler
    private void onRender2D(Render2DEvent event) {
        for (class_1297 entity : this.mc.field_1687.method_18112()) {
            class_1321 tameable;
            class_10583 owner;
            if (!(entity instanceof class_1321) || (owner = (tameable = (class_1321)entity).method_66287()) == null) continue;
            Utils.set(this.pos, entity, event.tickDelta);
            this.pos.add(0.0, (double)entity.method_18381(entity.method_18376()) + 0.75, 0.0);
            if (!NametagUtils.to2D(this.pos, this.scale.get())) continue;
            this.renderNametag(this.getOwnerName((class_10583<class_1309>)owner));
        }
    }

    private void renderNametag(String name) {
        TextRenderer text = TextRenderer.get();
        NametagUtils.begin(this.pos);
        text.beginBig();
        double w = text.getWidth(name);
        double x = -w / 2.0;
        double y = -text.getHeight();
        Renderer2D.COLOR.begin();
        Renderer2D.COLOR.quad(x - 1.0, y - 1.0, w + 2.0, text.getHeight() + 2.0, BACKGROUND);
        Renderer2D.COLOR.render();
        text.render(name, x, y, TEXT);
        text.end();
        NametagUtils.end();
    }

    private String getOwnerName(class_10583<class_1309> owner) {
        @Nullable class_1309 ownerEntity = (class_1309)owner.method_66255((class_10598)this.mc.field_1687, class_1309.class);
        if (ownerEntity instanceof class_1657) {
            class_1657 playerEntity = (class_1657)ownerEntity;
            return playerEntity.method_5477().getString();
        }
        UUID uuid = owner.method_66263();
        String name = this.uuidToName.get(uuid);
        if (name != null) {
            return name;
        }
        MeteorExecutor.execute(() -> {
            if (this.isActive()) {
                @Nullable ProfileResponse res = (ProfileResponse)Http.get("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid.toString().replace("-", "")).sendJson((Type)((Object)ProfileResponse.class));
                if (this.isActive()) {
                    if (res == null) {
                        this.uuidToName.put(uuid, "Failed to get name");
                    } else {
                        this.uuidToName.put(uuid, res.name);
                    }
                }
            }
        });
        name = "Retrieving";
        this.uuidToName.put(uuid, name);
        return name;
    }

    private static class ProfileResponse {
        public String name;

        private ProfileResponse() {
        }
    }
}

