/*
 * Decompiled with CFR 0.152.
 */
package org.meteordev.starscript;

import java.util.function.Supplier;
import org.meteordev.starscript.Instruction;
import org.meteordev.starscript.Script;
import org.meteordev.starscript.Section;
import org.meteordev.starscript.compiler.Expr;
import org.meteordev.starscript.compiler.Parser;
import org.meteordev.starscript.utils.CompletionCallback;
import org.meteordev.starscript.utils.Error;
import org.meteordev.starscript.utils.SFunction;
import org.meteordev.starscript.utils.Stack;
import org.meteordev.starscript.utils.StarscriptError;
import org.meteordev.starscript.value.Value;
import org.meteordev.starscript.value.ValueMap;

public class Starscript {
    private final ValueMap globals;
    private final Stack<Value> stack = new Stack();

    public Starscript() {
        this.globals = new ValueMap();
    }

    public Starscript(Starscript parent) {
        this.globals = parent.globals;
    }

    public Section run(Script script, StringBuilder sb) {
        this.stack.clear();
        sb.setLength(0);
        int ip = 0;
        Section firstSection = null;
        Section section = null;
        int index = 0;
        block44: while (true) {
            switch (Instruction.valueOf(script.code[ip++])) {
                case Constant: {
                    this.push(script.constants.get(script.code[ip++] & 0xFF));
                    continue block44;
                }
                case Null: {
                    this.push(Value.null_());
                    continue block44;
                }
                case True: {
                    this.push(Value.bool(true));
                    continue block44;
                }
                case False: {
                    this.push(Value.bool(false));
                    continue block44;
                }
                case Add: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number(a.getNumber() + b.getNumber()));
                        continue block44;
                    }
                    if (a.isString()) {
                        this.push(Value.string(a.getString() + b.toString()));
                        continue block44;
                    }
                    this.error("Can only add 2 numbers or 1 string and other value.", new Object[0]);
                    continue block44;
                }
                case Subtract: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number(a.getNumber() - b.getNumber()));
                        continue block44;
                    }
                    this.error("Can only subtract 2 numbers.", new Object[0]);
                    continue block44;
                }
                case Multiply: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number(a.getNumber() * b.getNumber()));
                        continue block44;
                    }
                    this.error("Can only multiply 2 numbers.", new Object[0]);
                    continue block44;
                }
                case Divide: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number(a.getNumber() / b.getNumber()));
                        continue block44;
                    }
                    this.error("Can only divide 2 numbers.", new Object[0]);
                    continue block44;
                }
                case Modulo: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number(a.getNumber() % b.getNumber()));
                        continue block44;
                    }
                    this.error("Can only modulo 2 numbers.", new Object[0]);
                    continue block44;
                }
                case Power: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number(Math.pow(a.getNumber(), b.getNumber())));
                        continue block44;
                    }
                    this.error("Can only power 2 numbers.", new Object[0]);
                    continue block44;
                }
                case BitwiseAnd: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number((long)a.getNumber() & (long)b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case BitwiseOr: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number((long)a.getNumber() | (long)b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case BitwiseXor: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number((long)a.getNumber() ^ (long)b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case LeftShift: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number((long)a.getNumber() << (int)b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case RightShift: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number((long)a.getNumber() >> (int)b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case UnsignedRightShift: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number((long)a.getNumber() >>> (int)b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case AddConstant: {
                    Value b = script.constants.get(script.code[ip++] & 0xFF);
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.number(a.getNumber() + b.getNumber()));
                        continue block44;
                    }
                    if (a.isString()) {
                        this.push(Value.string(a.getString() + b.toString()));
                        continue block44;
                    }
                    this.error("Can only add 2 numbers or 1 string and other value.", new Object[0]);
                    continue block44;
                }
                case Pop: {
                    this.pop();
                    continue block44;
                }
                case Not: {
                    this.push(Value.bool(!this.pop().isTruthy()));
                    continue block44;
                }
                case Negate: {
                    Value a = this.pop();
                    if (a.isNumber()) {
                        this.push(Value.number(-a.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires a number.", new Object[0]);
                    continue block44;
                }
                case BitwiseNot: {
                    Value a = this.pop();
                    if (a.isNumber()) {
                        this.push(Value.number((long)a.getNumber() ^ 0xFFFFFFFFFFFFFFFFL));
                        continue block44;
                    }
                    this.error("This operation requires a number.", new Object[0]);
                    continue block44;
                }
                case Equals: {
                    this.push(Value.bool(this.pop().equals(this.pop())));
                    continue block44;
                }
                case NotEquals: {
                    this.push(Value.bool(!this.pop().equals(this.pop())));
                    continue block44;
                }
                case Greater: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.bool(a.getNumber() > b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case GreaterEqual: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.bool(a.getNumber() >= b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case Less: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.bool(a.getNumber() < b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case LessEqual: {
                    Value b = this.pop();
                    Value a = this.pop();
                    if (a.isNumber() && b.isNumber()) {
                        this.push(Value.bool(a.getNumber() <= b.getNumber()));
                        continue block44;
                    }
                    this.error("This operation requires 2 numbers.", new Object[0]);
                    continue block44;
                }
                case Variable: {
                    String name = script.constants.get(script.code[ip++] & 0xFF).getString();
                    Supplier<Value> s = this.globals.getRaw(name);
                    this.push(s != null ? s.get() : Value.null_());
                    continue block44;
                }
                case Get: {
                    String name = script.constants.get(script.code[ip++] & 0xFF).getString();
                    Value v = this.pop();
                    if (!v.isMap()) {
                        this.push(Value.null_());
                        continue block44;
                    }
                    Supplier<Value> s = v.getMap().getRaw(name);
                    this.push(s != null ? s.get() : Value.null_());
                    continue block44;
                }
                case Call: {
                    Value r;
                    byte argCount = script.code[ip++];
                    Value a = this.peek(argCount);
                    if (a.isFunction()) {
                        r = a.getFunction().run(this, argCount);
                        this.pop();
                        this.push(r);
                        continue block44;
                    }
                    this.error("Tried to call a %s, can only call functions.", new Object[]{a.type});
                    continue block44;
                }
                case Jump: {
                    int jump = (script.code[ip++] & 0xFF) << 8 | script.code[ip++] & 0xFF;
                    ip += jump;
                    continue block44;
                }
                case JumpIfTrue: {
                    int jump = (script.code[ip++] & 0xFF) << 8 | script.code[ip++] & 0xFF;
                    if (!this.peek().isTruthy()) continue block44;
                    ip += jump;
                    continue block44;
                }
                case JumpIfFalse: {
                    int jump = (script.code[ip++] & 0xFF) << 8 | script.code[ip++] & 0xFF;
                    if (this.peek().isTruthy()) continue block44;
                    ip += jump;
                    continue block44;
                }
                case Section: {
                    section = firstSection == null ? (firstSection = new Section(index, sb.toString())) : (section.next = new Section(index, sb.toString()));
                    sb.setLength(0);
                    index = script.code[ip++];
                    continue block44;
                }
                case Append: {
                    sb.append(this.pop().toString());
                    continue block44;
                }
                case ConstantAppend: {
                    sb.append(script.constants.get(script.code[ip++] & 0xFF).toString());
                    continue block44;
                }
                case VariableAppend: {
                    Supplier<Value> s = this.globals.getRaw(script.constants.get(script.code[ip++] & 0xFF).getString());
                    sb.append((s == null ? Value.null_() : s.get()).toString());
                    continue block44;
                }
                case GetAppend: {
                    String name = script.constants.get(script.code[ip++] & 0xFF).getString();
                    Value v = this.pop();
                    if (!v.isMap()) {
                        sb.append(Value.null_());
                        continue block44;
                    }
                    Supplier<Value> s = v.getMap().getRaw(name);
                    sb.append((s != null ? s.get() : Value.null_()).toString());
                    continue block44;
                }
                case CallAppend: {
                    Value r;
                    byte argCount = script.code[ip++];
                    Value a = this.peek(argCount);
                    if (a.isFunction()) {
                        r = a.getFunction().run(this, argCount);
                        this.pop();
                        sb.append(r.toString());
                        continue block44;
                    }
                    this.error("Tried to call a %s, can only call functions.", new Object[]{a.type});
                    continue block44;
                }
                case VariableGet: {
                    String name = script.constants.get(script.code[ip++] & 0xFF).getString();
                    Supplier<Value> s = this.globals.getRaw(name);
                    Value v = s != null ? s.get() : Value.null_();
                    name = script.constants.get(script.code[ip++] & 0xFF).getString();
                    if (!v.isMap()) {
                        this.push(Value.null_());
                        continue block44;
                    }
                    s = v.getMap().getRaw(name);
                    this.push(s != null ? s.get() : Value.null_());
                    continue block44;
                }
                case VariableGetAppend: {
                    String name = script.constants.get(script.code[ip++] & 0xFF).getString();
                    Supplier<Value> s = this.globals.getRaw(name);
                    Value v = s != null ? s.get() : Value.null_();
                    name = script.constants.get(script.code[ip++] & 0xFF).getString();
                    if (!v.isMap()) {
                        this.push(Value.null_());
                        continue block44;
                    }
                    s = v.getMap().getRaw(name);
                    v = s != null ? s.get() : Value.null_();
                    sb.append(v.toString());
                    continue block44;
                }
                case End: {
                    break block44;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown instruction '" + (Object)((Object)Instruction.valueOf(script.code[ip])) + "'");
                }
            }
            break;
        }
        if (firstSection != null) {
            section.next = new Section(index, sb.toString());
            return firstSection;
        }
        return new Section(index, sb.toString());
    }

    public Section run(Script script) {
        return this.run(script, new StringBuilder());
    }

    public void push(Value value) {
        this.stack.push(value);
    }

    public Value pop() {
        return this.stack.pop();
    }

    public Value peek() {
        if (this.stack.size() == 0) {
            return Value.null_();
        }
        return this.stack.peek();
    }

    public Value peek(int offset) {
        if (this.stack.size() <= offset) {
            return Value.null_();
        }
        return this.stack.peek(offset);
    }

    public boolean popBool(String errorMsg) {
        Value a = this.pop();
        if (!a.isBool()) {
            this.error(errorMsg, new Object[0]);
        }
        return a.getBool();
    }

    public double popNumber(String errorMsg) {
        Value a = this.pop();
        if (!a.isNumber()) {
            this.error(errorMsg, new Object[0]);
        }
        return a.getNumber();
    }

    public String popString(String errorMsg) {
        Value a = this.pop();
        if (!a.isString()) {
            this.error(errorMsg, new Object[0]);
        }
        return a.getString();
    }

    public Object popObject(String errorMsg) {
        Value a = this.pop();
        if (!a.isObject()) {
            this.error(errorMsg, new Object[0]);
        }
        return a.getObject();
    }

    public void error(String format, Object ... args) {
        throw new StarscriptError(String.format(format, args));
    }

    public ValueMap set(String name, Supplier<Value> supplier) {
        return this.globals.set(name, supplier);
    }

    public ValueMap set(String name, Value value) {
        return this.globals.set(name, value);
    }

    public ValueMap set(String name, boolean bool) {
        return this.globals.set(name, bool);
    }

    public ValueMap set(String name, double number) {
        return this.globals.set(name, number);
    }

    public ValueMap set(String name, String string) {
        return this.globals.set(name, string);
    }

    public ValueMap set(String name, SFunction function) {
        return this.globals.set(name, function);
    }

    public ValueMap set(String name, ValueMap map) {
        return this.globals.set(name, map);
    }

    public ValueMap set(String name, Object object) {
        return this.globals.set(name, object);
    }

    public void clear() {
        this.globals.clear();
    }

    public Supplier<Value> remove(String name) {
        return this.globals.remove(name);
    }

    public ValueMap getGlobals() {
        return this.globals;
    }

    public void getCompletions(String source, int position, CompletionCallback callback) {
        Parser.Result result = Parser.parse(source);
        for (Expr expr : result.exprs) {
            this.completionsExpr(source, position, expr, callback);
        }
        for (Error error : result.errors) {
            if (error.expr == null) continue;
            this.completionsExpr(source, position, error.expr, callback);
        }
    }

    private void completionsExpr(String source, int position, Expr expr, CompletionCallback callback) {
        block12: {
            block13: {
                block14: {
                    block11: {
                        if (position < expr.start || position > expr.end && position != source.length()) {
                            return;
                        }
                        if (!(expr instanceof Expr.Variable)) break block11;
                        Expr.Variable var = (Expr.Variable)expr;
                        String start = source.substring(var.start, position);
                        for (String key : this.globals.keys()) {
                            if (key.startsWith("_") || !key.startsWith(start)) continue;
                            callback.onCompletion(key, this.globals.getRaw(key).get().isFunction());
                        }
                        break block12;
                    }
                    if (!(expr instanceof Expr.Get)) break block13;
                    Expr.Get get = (Expr.Get)expr;
                    if (position < get.end - get.name.length()) break block14;
                    Value value = this.resolveExpr(get.getObject());
                    if (value == null || !value.isMap()) break block12;
                    String start = source.substring(get.getObject().end + 1, position);
                    for (String key : value.getMap().keys()) {
                        if (key.startsWith("_") || !key.startsWith(start)) continue;
                        callback.onCompletion(key, value.getMap().getRaw(key).get().isFunction());
                    }
                    break block12;
                }
                for (Expr child : expr.children) {
                    this.completionsExpr(source, position, child, callback);
                }
                break block12;
            }
            if (expr instanceof Expr.Block) {
                if (((Expr.Block)expr).getExpr() == null) {
                    for (String key : this.globals.keys()) {
                        if (key.startsWith("_")) continue;
                        callback.onCompletion(key, this.globals.getRaw(key).get().isFunction());
                    }
                } else {
                    for (Expr child : expr.children) {
                        this.completionsExpr(source, position, child, callback);
                    }
                }
            } else {
                for (Expr child : expr.children) {
                    this.completionsExpr(source, position, child, callback);
                }
            }
        }
    }

    private Value resolveExpr(Expr expr) {
        if (expr instanceof Expr.Variable) {
            Supplier<Value> supplier = this.globals.getRaw(((Expr.Variable)expr).name);
            return supplier != null ? supplier.get() : null;
        }
        if (expr instanceof Expr.Get) {
            Value value = this.resolveExpr(((Expr.Get)expr).getObject());
            if (value == null || !value.isMap()) {
                return null;
            }
            Supplier<Value> supplier = value.getMap().getRaw(((Expr.Get)expr).name);
            return supplier != null ? supplier.get() : null;
        }
        return null;
    }
}

