/*
 * Decompiled with CFR 0.152.
 */
package org.meteordev.starscript.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.meteordev.starscript.compiler.Expr;
import org.meteordev.starscript.utils.AbstractExprVisitor;

public class VariableReplacementTransformer
extends AbstractExprVisitor {
    private final Map<String, Supplier<String>> replacers = new HashMap<String, Supplier<String>>();
    private final StringBuilder sb = new StringBuilder();

    public void addReplacer(String name, Supplier<String> supplier) {
        this.replacers.put(name, supplier);
    }

    @Override
    public void visitVariable(Expr.Variable expr) {
        this.tryReplace(expr, expr.name);
    }

    @Override
    public void visitGet(Expr.Get expr) {
        String name = this.getFullName(expr);
        if (name != null) {
            this.tryReplace(expr, name);
        }
    }

    private void tryReplace(Expr expr, String name) {
        Supplier<String> replacer = this.replacers.get(name);
        if (replacer == null) {
            return;
        }
        Expr replacement = this.createReplacement(replacer.get());
        expr.replace(replacement);
    }

    private Expr createReplacement(String replacement) {
        String[] parts = replacement.split("\\.");
        if (parts.length == 0) {
            throw new IllegalStateException("Cannot replace with an empty replacement");
        }
        Expr expr = null;
        for (int i = 0; i < parts.length; ++i) {
            expr = i == 0 ? new Expr.Variable(0, 0, parts[i]) : new Expr.Get(0, 0, expr, parts[i]);
        }
        return expr;
    }

    private String getFullName(Expr.Get expr) {
        try {
            this.getFullNameImpl(expr);
        }
        catch (IllegalStateException ignored) {
            this.sb.setLength(0);
            return null;
        }
        String name = this.sb.toString();
        this.sb.setLength(0);
        return name;
    }

    private void getFullNameImpl(Expr.Get expr) {
        if (expr.getObject() instanceof Expr.Get) {
            this.getFullNameImpl((Expr.Get)expr.getObject());
        } else if (expr.getObject() instanceof Expr.Variable) {
            this.sb.append(((Expr.Variable)expr.getObject()).name);
        } else {
            throw new IllegalStateException();
        }
        this.sb.append('.');
        this.sb.append(expr.name);
    }
}

