/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.systems.modules.movement;

import java.util.ArrayList;
import java.util.List;
import meteordevelopment.meteorclient.events.packets.PacketEvent;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.settings.BoolSetting;
import meteordevelopment.meteorclient.settings.IntSetting;
import meteordevelopment.meteorclient.settings.KeybindSetting;
import meteordevelopment.meteorclient.settings.Setting;
import meteordevelopment.meteorclient.settings.SettingGroup;
import meteordevelopment.meteorclient.systems.modules.Categories;
import meteordevelopment.meteorclient.systems.modules.Module;
import meteordevelopment.meteorclient.utils.Utils;
import meteordevelopment.meteorclient.utils.entity.fakeplayer.FakePlayerEntity;
import meteordevelopment.meteorclient.utils.misc.Keybind;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_634;
import org.joml.Vector3d;

public class Blink
extends Module {
    private final SettingGroup sgGeneral;
    private final Setting<Boolean> renderOriginal;
    private final Setting<Integer> delay;
    private final Setting<Keybind> cancelBlink;
    private final List<class_2828> packets;
    private FakePlayerEntity model;
    private final Vector3d start;
    private boolean cancelled;
    private boolean sending;
    private int timer;

    public Blink() {
        super(Categories.Movement, "blink", "Allows you to essentially teleport while suspending motion updates.");
        this.sgGeneral = this.settings.getDefaultGroup();
        this.renderOriginal = this.sgGeneral.add(((BoolSetting.Builder)((BoolSetting.Builder)((BoolSetting.Builder)new BoolSetting.Builder().name("render-original")).description("Renders your player model at the original position.")).defaultValue(true)).build());
        this.delay = this.sgGeneral.add(((IntSetting.Builder)((IntSetting.Builder)((IntSetting.Builder)new IntSetting.Builder().name("pulse-delay")).description("After the duration in ticks has elapsed, send all packets and start blinking again. 0 to disable.")).defaultValue(0)).min(0).sliderMax(60).build());
        this.cancelBlink = this.sgGeneral.add(((KeybindSetting.Builder)((KeybindSetting.Builder)((KeybindSetting.Builder)new KeybindSetting.Builder().name("cancel-blink")).description("Cancels sending packets and sends you back to your original position.")).defaultValue(Keybind.none())).action(() -> {
            this.cancelled = true;
            if (this.isActive()) {
                this.toggle();
            }
        }).build());
        this.packets = new ArrayList<class_2828>();
        this.start = new Vector3d();
        this.timer = 0;
    }

    @Override
    public void onActivate() {
        if (this.renderOriginal.get().booleanValue()) {
            this.model = new FakePlayerEntity((class_1657)this.mc.field_1724, this.mc.field_1724.method_7334().getName(), 20.0f, true);
            this.model.doNotPush = true;
            this.model.hideWhenInsideCamera = true;
            this.model.noHit = true;
            this.model.spawn();
        }
        Utils.set(this.start, this.mc.field_1724.method_19538());
    }

    @Override
    public void onDeactivate() {
        this.dumpPackets(!this.cancelled);
        if (this.cancelled) {
            this.mc.field_1724.method_23327(this.start.x, this.start.y, this.start.z);
            this.mc.field_1724.method_18799(class_243.field_1353);
        }
        this.cancelled = false;
    }

    @EventHandler
    private void onTick(TickEvent.Post event) {
        ++this.timer;
        if (this.delay.get() != 0 && this.delay.get() <= this.timer) {
            this.onDeactivate();
            this.onActivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventHandler
    private void onSendPacket(PacketEvent.Send event) {
        class_2828 prev;
        if (this.sending) {
            return;
        }
        class_2596<?> class_25962 = event.packet;
        if (!(class_25962 instanceof class_2828)) {
            return;
        }
        class_2828 p = (class_2828)class_25962;
        event.cancel();
        class_2828 class_28282 = prev = this.packets.isEmpty() ? null : this.packets.getLast();
        if (prev != null && p.method_12273() == prev.method_12273() && p.method_12271(-1.0f) == prev.method_12271(-1.0f) && p.method_12270(-1.0f) == prev.method_12270(-1.0f) && p.method_12269(-1.0) == prev.method_12269(-1.0) && p.method_12268(-1.0) == prev.method_12268(-1.0) && p.method_12274(-1.0) == prev.method_12274(-1.0)) {
            return;
        }
        List<class_2828> list = this.packets;
        synchronized (list) {
            this.packets.add(p);
        }
    }

    @Override
    public String getInfoString() {
        return String.format("%.1f", Float.valueOf((float)this.timer / 20.0f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpPackets(boolean send) {
        this.sending = true;
        List<class_2828> list = this.packets;
        synchronized (list) {
            if (send) {
                this.packets.forEach(arg_0 -> ((class_634)this.mc.field_1724.field_3944).method_52787(arg_0));
            }
            this.packets.clear();
        }
        this.sending = false;
        if (this.model != null) {
            this.model.despawn();
            this.model = null;
        }
        this.timer = 0;
    }
}

