/*
 * Decompiled with CFR 0.152.
 */
package meteordevelopment.meteorclient.utils;

import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import meteordevelopment.meteorclient.MeteorClient;
import meteordevelopment.meteorclient.events.world.TickEvent;
import meteordevelopment.meteorclient.gui.tabs.TabScreen;
import meteordevelopment.meteorclient.mixin.ClientPlayNetworkHandlerAccessor;
import meteordevelopment.meteorclient.mixin.ContainerComponentAccessor;
import meteordevelopment.meteorclient.mixin.MinecraftClientAccessor;
import meteordevelopment.meteorclient.mixin.MinecraftServerAccessor;
import meteordevelopment.meteorclient.mixin.ProjectionMatrix2Accessor;
import meteordevelopment.meteorclient.mixin.ReloadStateAccessor;
import meteordevelopment.meteorclient.mixin.ResourceReloadLoggerAccessor;
import meteordevelopment.meteorclient.mixininterface.IMinecraftClient;
import meteordevelopment.meteorclient.settings.StatusEffectAmplifierMapSetting;
import meteordevelopment.meteorclient.systems.modules.Modules;
import meteordevelopment.meteorclient.systems.modules.render.BetterTooltips;
import meteordevelopment.meteorclient.systems.modules.world.Timer;
import meteordevelopment.meteorclient.utils.PreInit;
import meteordevelopment.meteorclient.utils.misc.Names;
import meteordevelopment.meteorclient.utils.player.EChestMemory;
import meteordevelopment.meteorclient.utils.render.PeekScreen;
import meteordevelopment.meteorclient.utils.render.RenderUtils;
import meteordevelopment.meteorclient.utils.render.color.Color;
import meteordevelopment.meteorclient.utils.world.BlockEntityIterator;
import meteordevelopment.meteorclient.utils.world.ChunkIterator;
import meteordevelopment.orbit.EventHandler;
import net.minecraft.class_10366;
import net.minecraft.class_11278;
import net.minecraft.class_11343;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1767;
import net.minecraft.class_1771;
import net.minecraft.class_1776;
import net.minecraft.class_1779;
import net.minecraft.class_1787;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1803;
import net.minecraft.class_1823;
import net.minecraft.class_1828;
import net.minecraft.class_1835;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2791;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_526;
import net.minecraft.class_5321;
import net.minecraft.class_6360;
import net.minecraft.class_6880;
import net.minecraft.class_9279;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Range;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.lwjgl.glfw.GLFW;

public class Utils {
    public static final Pattern FILE_NAME_INVALID_CHARS_PATTERN = Pattern.compile("[\\s\\\\/:*?\"<>|]");
    public static final Color WHITE = new Color(255, 255, 255);
    private static final Random random = new Random();
    public static boolean isReleasingTrident;
    public static boolean rendering3D;
    public static double frameTime;
    public static class_437 screenToOpen;
    private static final class_11278 matrix;

    private Utils() {
    }

    @PreInit
    public static void init() {
        MeteorClient.EVENT_BUS.subscribe(Utils.class);
    }

    @EventHandler
    private static void onTick(TickEvent.Post event) {
        if (screenToOpen != null && MeteorClient.mc.field_1755 == null) {
            MeteorClient.mc.method_1507(screenToOpen);
            screenToOpen = null;
        }
    }

    public static class_243 getPlayerSpeed() {
        if (MeteorClient.mc.field_1724 == null) {
            return class_243.field_1353;
        }
        double tX = MeteorClient.mc.field_1724.method_23317() - MeteorClient.mc.field_1724.field_6014;
        double tY = MeteorClient.mc.field_1724.method_23318() - MeteorClient.mc.field_1724.field_6036;
        double tZ = MeteorClient.mc.field_1724.method_23321() - MeteorClient.mc.field_1724.field_5969;
        Timer timer = Modules.get().get(Timer.class);
        if (timer.isActive()) {
            tX *= timer.getMultiplier();
            tY *= timer.getMultiplier();
            tZ *= timer.getMultiplier();
        }
        return new class_243(tX *= 20.0, tY *= 20.0, tZ *= 20.0);
    }

    public static String getWorldTime() {
        if (MeteorClient.mc.field_1687 == null) {
            return "00:00";
        }
        int ticks = (int)(MeteorClient.mc.field_1687.method_8532() % 24000L);
        if ((ticks += 6000) > 24000) {
            ticks -= 24000;
        }
        return String.format("%02d:%02d", ticks / 1000, (int)((double)(ticks % 1000) / 1000.0 * 60.0));
    }

    public static Iterable<class_2791> chunks(boolean onlyWithLoadedNeighbours) {
        return () -> new ChunkIterator(onlyWithLoadedNeighbours);
    }

    public static Iterable<class_2791> chunks() {
        return Utils.chunks(false);
    }

    public static Iterable<class_2586> blockEntities() {
        return BlockEntityIterator::new;
    }

    public static void getEnchantments(class_1799 itemStack, Object2IntMap<class_6880<class_1887>> enchantments) {
        enchantments.clear();
        if (!itemStack.method_7960()) {
            Set itemEnchantments = itemStack.method_7909() == class_1802.field_8598 ? ((class_9304)itemStack.method_58695(class_9334.field_49643, (Object)class_9304.field_49385)).method_57539() : itemStack.method_58657().method_57539();
            for (Object2IntMap.Entry entry : itemEnchantments) {
                enchantments.put((Object)((class_6880)entry.getKey()), entry.getIntValue());
            }
        }
    }

    public static int getEnchantmentLevel(class_1799 itemStack, class_5321<class_1887> enchantment) {
        if (itemStack.method_7960()) {
            return 0;
        }
        Object2IntArrayMap itemEnchantments = new Object2IntArrayMap();
        Utils.getEnchantments(itemStack, (Object2IntMap<class_6880<class_1887>>)itemEnchantments);
        return Utils.getEnchantmentLevel((Object2IntMap<class_6880<class_1887>>)itemEnchantments, enchantment);
    }

    public static int getEnchantmentLevel(Object2IntMap<class_6880<class_1887>> itemEnchantments, class_5321<class_1887> enchantment) {
        for (Object2IntMap.Entry entry : Object2IntMaps.fastIterable(itemEnchantments)) {
            if (!((class_6880)entry.getKey()).method_40225(enchantment)) continue;
            return entry.getIntValue();
        }
        return 0;
    }

    @SafeVarargs
    public static boolean hasEnchantments(class_1799 itemStack, class_5321<class_1887> ... enchantments) {
        if (itemStack.method_7960()) {
            return false;
        }
        Object2IntArrayMap itemEnchantments = new Object2IntArrayMap();
        Utils.getEnchantments(itemStack, (Object2IntMap<class_6880<class_1887>>)itemEnchantments);
        for (class_5321<class_1887> enchantment : enchantments) {
            if (Utils.hasEnchantment((Object2IntMap<class_6880<class_1887>>)itemEnchantments, enchantment)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasEnchantment(class_1799 itemStack, class_5321<class_1887> enchantmentKey) {
        if (itemStack.method_7960()) {
            return false;
        }
        Object2IntArrayMap itemEnchantments = new Object2IntArrayMap();
        Utils.getEnchantments(itemStack, (Object2IntMap<class_6880<class_1887>>)itemEnchantments);
        return Utils.hasEnchantment((Object2IntMap<class_6880<class_1887>>)itemEnchantments, enchantmentKey);
    }

    private static boolean hasEnchantment(Object2IntMap<class_6880<class_1887>> itemEnchantments, class_5321<class_1887> enchantmentKey) {
        for (class_6880 enchantment : itemEnchantments.keySet()) {
            if (!enchantment.method_40225(enchantmentKey)) continue;
            return true;
        }
        return false;
    }

    public static int getRenderDistance() {
        return Math.max((Integer)MeteorClient.mc.field_1690.method_42503().method_41753(), ((ClientPlayNetworkHandlerAccessor)MeteorClient.mc.method_1562()).meteor$getChunkLoadDistance());
    }

    public static int getWindowWidth() {
        return MeteorClient.mc.method_22683().method_4489();
    }

    public static int getWindowHeight() {
        return MeteorClient.mc.method_22683().method_4506();
    }

    public static void unscaledProjection() {
        float width = MeteorClient.mc.method_22683().method_4489();
        float height = MeteorClient.mc.method_22683().method_4506();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)matrix.method_71092(width, height), (class_10366)class_10366.field_54954);
        RenderUtils.projection.set((Matrix4fc)((ProjectionMatrix2Accessor)matrix).meteor$callGetMatrix(width, height));
        rendering3D = false;
    }

    public static void scaledProjection() {
        float width = MeteorClient.mc.method_22683().method_4489() / MeteorClient.mc.method_22683().method_4495();
        float height = MeteorClient.mc.method_22683().method_4506() / MeteorClient.mc.method_22683().method_4495();
        RenderSystem.setProjectionMatrix((GpuBufferSlice)matrix.method_71092(width, height), (class_10366)class_10366.field_54953);
        RenderUtils.projection.set((Matrix4fc)((ProjectionMatrix2Accessor)matrix).meteor$callGetMatrix(width, height));
        rendering3D = true;
    }

    public static class_243 vec3d(class_2338 pos) {
        return new class_243((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260());
    }

    public static boolean openContainer(class_1799 itemStack, class_1799[] contents, boolean pause) {
        if (Utils.hasItems(itemStack) || itemStack.method_7909() == class_1802.field_8466) {
            Utils.getItemsInContainerItem(itemStack, contents);
            if (pause) {
                screenToOpen = new PeekScreen(itemStack, contents);
            } else {
                MeteorClient.mc.method_1507((class_437)new PeekScreen(itemStack, contents));
            }
            return true;
        }
        return false;
    }

    public static void getItemsInContainerItem(class_1799 itemStack, class_1799[] items) {
        block9: {
            class_9323 components;
            block8: {
                if (itemStack.method_7909() == class_1802.field_8466) {
                    for (int i = 0; i < EChestMemory.ITEMS.size(); ++i) {
                        items[i] = (class_1799)EChestMemory.ITEMS.get(i);
                    }
                    return;
                }
                Arrays.fill(items, class_1799.field_8037);
                components = itemStack.method_57353();
                if (!components.method_57832(class_9334.field_49622)) break block8;
                ContainerComponentAccessor container = (ContainerComponentAccessor)components.method_58694(class_9334.field_49622);
                class_2371<class_1799> stacks = container.meteor$getStacks();
                for (int i = 0; i < stacks.size(); ++i) {
                    if (i < 0 || i >= items.length) continue;
                    items[i] = (class_1799)stacks.get(i);
                }
                break block9;
            }
            if (!components.method_57832(class_9334.field_49611)) break block9;
            class_9279 nbt2 = (class_9279)components.method_58695(class_9334.field_49611, (Object)class_9279.field_49302);
            class_2499 nbt3 = nbt2.method_57463().method_68569("Items");
            block6: for (int i = 0; i < nbt3.size(); ++i) {
                DataResult dataResult;
                Optional slot;
                Optional compound = nbt3.method_10602(i);
                if (compound.isEmpty() || (slot = ((class_2487)compound.get()).method_10571("Slot")).isEmpty() || (Byte)slot.get() < 0 || (Byte)slot.get() >= items.length) continue;
                Objects.requireNonNull(class_11343.field_60354.parse((DynamicOps)MeteorClient.mc.field_1724.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)((class_2520)compound.get())));
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DataResult.Success.class, DataResult.Error.class}, (Object)dataResult, n)) {
                    case 0: {
                        DataResult.Success success = (DataResult.Success)dataResult;
                        items[((Byte)slot.get()).byteValue()] = ((class_11343)success.value()).comp_4212();
                        continue block6;
                    }
                    case 1: {
                        DataResult.Error ignored = (DataResult.Error)dataResult;
                        items[((Byte)slot.get()).byteValue()] = class_1799.field_8037;
                        continue block6;
                    }
                    default: {
                        throw new MatchException(null, null);
                    }
                }
            }
        }
    }

    public static Color getShulkerColor(class_1799 shulkerItem) {
        class_1792 class_17922 = shulkerItem.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            if (block == class_2246.field_10443) {
                return BetterTooltips.ECHEST_COLOR;
            }
            if (block instanceof class_2480) {
                class_2480 shulkerBlock = (class_2480)block;
                class_1767 dye = shulkerBlock.method_10528();
                if (dye == null) {
                    return WHITE;
                }
                int color = dye.method_7787();
                return new Color(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, 255);
            }
        }
        return WHITE;
    }

    public static boolean hasItems(class_1799 itemStack) {
        ContainerComponentAccessor container = (ContainerComponentAccessor)itemStack.method_58694(class_9334.field_49622);
        if (container != null && !container.meteor$getStacks().isEmpty()) {
            return true;
        }
        class_2487 compoundTag = ((class_9279)itemStack.method_58695(class_9334.field_49611, (Object)class_9279.field_49302)).method_57463();
        return compoundTag != null && compoundTag.method_10545("Items");
    }

    public static Reference2IntMap<class_1291> createStatusEffectMap() {
        return new Reference2IntArrayMap(StatusEffectAmplifierMapSetting.EMPTY_STATUS_EFFECT_MAP);
    }

    public static String getEnchantSimpleName(class_6880<class_1887> enchantment, int length) {
        String name = Names.get(enchantment);
        return name.length() > length ? name.substring(0, length) : name;
    }

    public static boolean searchTextDefault(String text, String filter, boolean caseSensitive) {
        return Utils.searchInWords(text, filter) > 0 || Utils.searchLevenshteinDefault(text, filter, caseSensitive) < text.length() / 2;
    }

    public static int searchLevenshteinDefault(String text, String filter, boolean caseSensitive) {
        return Utils.levenshteinDistance(caseSensitive ? filter : filter.toLowerCase(Locale.ROOT), caseSensitive ? text : text.toLowerCase(Locale.ROOT), 1, 8, 8);
    }

    public static int searchInWords(String text, String filter) {
        String[] words;
        if (filter.isEmpty()) {
            return 1;
        }
        int wordsFound = 0;
        text = text.toLowerCase(Locale.ROOT);
        for (String word : words = filter.toLowerCase(Locale.ROOT).split(" ")) {
            if (!text.contains(word)) {
                return 0;
            }
            wordsFound += StringUtils.countMatches((CharSequence)text, (CharSequence)word);
        }
        return wordsFound;
    }

    public static int levenshteinDistance(String from, String to, int insCost, int subCost, int delCost) {
        int i;
        int textLength = from.length();
        int filterLength = to.length();
        if (textLength == 0) {
            return filterLength * insCost;
        }
        if (filterLength == 0) {
            return textLength * delCost;
        }
        int[][] d = new int[textLength + 1][filterLength + 1];
        for (i = 0; i <= textLength; ++i) {
            d[i][0] = i * delCost;
        }
        for (int j = 0; j <= filterLength; ++j) {
            d[0][j] = j * insCost;
        }
        for (i = 1; i <= textLength; ++i) {
            for (int j = 1; j <= filterLength; ++j) {
                int sCost = d[i - 1][j - 1] + (from.charAt(i - 1) == to.charAt(j - 1) ? 0 : subCost);
                int dCost = d[i - 1][j] + delCost;
                int iCost = d[i][j - 1] + insCost;
                d[i][j] = Math.min(Math.min(dCost, iCost), sCost);
            }
        }
        return d[textLength][filterLength];
    }

    public static double squaredDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dX = x2 - x1;
        double dY = y2 - y1;
        double dZ = z2 - z1;
        return dX * dX + dY * dY + dZ * dZ;
    }

    public static double distance(double x1, double y1, double z1, double x2, double y2, double z2) {
        double dX = x2 - x1;
        double dY = y2 - y1;
        double dZ = z2 - z1;
        return Math.sqrt(dX * dX + dY * dY + dZ * dZ);
    }

    public static String getFileWorldName() {
        return FILE_NAME_INVALID_CHARS_PATTERN.matcher(Utils.getWorldName()).replaceAll("_");
    }

    public static String getWorldName() {
        if (MeteorClient.mc.method_1542()) {
            if (MeteorClient.mc.field_1687 == null) {
                return "";
            }
            if (MeteorClient.mc.method_1576() == null) {
                return "FAILED_BECAUSE_LEFT_WORLD";
            }
            File folder = ((MinecraftServerAccessor)MeteorClient.mc.method_1576()).meteor$getSession().method_27424(MeteorClient.mc.field_1687.method_27983()).toFile();
            if (folder.toPath().relativize(MeteorClient.mc.field_1697.toPath()).getNameCount() != 2) {
                folder = folder.getParentFile();
            }
            return folder.getName();
        }
        if (MeteorClient.mc.method_1558() != null) {
            return MeteorClient.mc.method_1558().method_52811() ? "realms" : MeteorClient.mc.method_1558().field_3761;
        }
        return "";
    }

    public static String nameToTitle(String name) {
        return Arrays.stream(name.split("-")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public static String titleToName(String title) {
        return title.replace(" ", "-").toLowerCase(Locale.ROOT);
    }

    public static String getKeyName(int key) {
        return switch (key) {
            case -1 -> "Unknown";
            case 256 -> "Esc";
            case 96 -> "Grave Accent";
            case 161 -> "World 1";
            case 162 -> "World 2";
            case 283 -> "Print Screen";
            case 284 -> "Pause";
            case 260 -> "Insert";
            case 261 -> "Delete";
            case 268 -> "Home";
            case 266 -> "Page Up";
            case 267 -> "Page Down";
            case 269 -> "End";
            case 258 -> "Tab";
            case 341 -> "Left Control";
            case 345 -> "Right Control";
            case 342 -> "Left Alt";
            case 346 -> "Right Alt";
            case 340 -> "Left Shift";
            case 344 -> "Right Shift";
            case 265 -> "Arrow Up";
            case 264 -> "Arrow Down";
            case 263 -> "Arrow Left";
            case 262 -> "Arrow Right";
            case 39 -> "Apostrophe";
            case 259 -> "Backspace";
            case 280 -> "Caps Lock";
            case 348 -> "Menu";
            case 343 -> "Left Super";
            case 347 -> "Right Super";
            case 257 -> "Enter";
            case 335 -> "Numpad Enter";
            case 282 -> "Num Lock";
            case 32 -> "Space";
            case 290 -> "F1";
            case 291 -> "F2";
            case 292 -> "F3";
            case 293 -> "F4";
            case 294 -> "F5";
            case 295 -> "F6";
            case 296 -> "F7";
            case 297 -> "F8";
            case 298 -> "F9";
            case 299 -> "F10";
            case 300 -> "F11";
            case 301 -> "F12";
            case 302 -> "F13";
            case 303 -> "F14";
            case 304 -> "F15";
            case 305 -> "F16";
            case 306 -> "F17";
            case 307 -> "F18";
            case 308 -> "F19";
            case 309 -> "F20";
            case 310 -> "F21";
            case 311 -> "F22";
            case 312 -> "F23";
            case 313 -> "F24";
            case 314 -> "F25";
            default -> {
                String keyName = GLFW.glfwGetKeyName((int)key, (int)0);
                if (keyName == null) {
                    yield "Unknown";
                }
                yield StringUtils.capitalize((String)keyName);
            }
        };
    }

    public static String getButtonName(int button) {
        return switch (button) {
            case -1 -> "Unknown";
            case 0 -> "Mouse Left";
            case 1 -> "Mouse Right";
            case 2 -> "Mouse Middle";
            default -> "Mouse " + button;
        };
    }

    public static byte[] readBytes(InputStream in) {
        try {
            byte[] byArray = in.readAllBytes();
            return byArray;
        }
        catch (IOException e) {
            MeteorClient.LOG.error("Error reading from stream.", (Throwable)e);
            byte[] byArray = new byte[]{};
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    public static boolean canUpdate() {
        return MeteorClient.mc != null && MeteorClient.mc.field_1687 != null && MeteorClient.mc.field_1724 != null;
    }

    public static boolean canOpenGui() {
        if (Utils.canUpdate()) {
            return MeteorClient.mc.field_1755 == null;
        }
        return MeteorClient.mc.field_1755 instanceof class_442 || MeteorClient.mc.field_1755 instanceof class_500 || MeteorClient.mc.field_1755 instanceof class_526;
    }

    public static boolean canCloseGui() {
        return MeteorClient.mc.field_1755 instanceof TabScreen;
    }

    public static int random(int min, int max) {
        return random.nextInt(max - min) + min;
    }

    public static double random(double min, double max) {
        return min + (max - min) * random.nextDouble();
    }

    public static void leftClick() {
        int attackCooldown = ((MinecraftClientAccessor)MeteorClient.mc).meteor$getAttackCooldown();
        if (attackCooldown == 10000) {
            ((MinecraftClientAccessor)MeteorClient.mc).meteor$setAttackCooldown(0);
        }
        MeteorClient.mc.field_1690.field_1886.method_23481(true);
        ((MinecraftClientAccessor)MeteorClient.mc).meteor$leftClick();
        MeteorClient.mc.field_1690.field_1886.method_23481(false);
    }

    public static void rightClick() {
        ((IMinecraftClient)MeteorClient.mc).meteor$rightClick();
    }

    public static boolean isShulker(class_1792 item) {
        return item == class_1802.field_8545 || item == class_1802.field_8722 || item == class_1802.field_8380 || item == class_1802.field_8050 || item == class_1802.field_8829 || item == class_1802.field_8271 || item == class_1802.field_8548 || item == class_1802.field_8520 || item == class_1802.field_8627 || item == class_1802.field_8451 || item == class_1802.field_8213 || item == class_1802.field_8816 || item == class_1802.field_8350 || item == class_1802.field_8584 || item == class_1802.field_8461 || item == class_1802.field_8676 || item == class_1802.field_8268;
    }

    public static boolean isThrowable(class_1792 item) {
        return item instanceof class_1779 || item instanceof class_1753 || item instanceof class_1764 || item instanceof class_1823 || item instanceof class_1771 || item instanceof class_1776 || item instanceof class_1828 || item instanceof class_1803 || item instanceof class_1787 || item instanceof class_1835;
    }

    public static void addEnchantment(class_1799 itemStack, class_6880<class_1887> enchantment, int level) {
        class_9304.class_9305 b = new class_9304.class_9305(class_1890.method_57532((class_1799)itemStack));
        b.method_57550(enchantment, level);
        class_1890.method_57530((class_1799)itemStack, (class_9304)b.method_57549());
    }

    public static void clearEnchantments(class_1799 itemStack) {
        class_1890.method_57531((class_1799)itemStack, components -> components.method_57548(a -> true));
    }

    public static void removeEnchantment(class_1799 itemStack, class_1887 enchantment) {
        class_1890.method_57531((class_1799)itemStack, components -> components.method_57548(enchantment1 -> ((class_1887)enchantment1.comp_349()).equals((Object)enchantment)));
    }

    public static Color lerp(Color first, Color second, @Range(from=0L, to=1L) float v) {
        return new Color((int)((float)first.r * (1.0f - v) + (float)second.r * v), (int)((float)first.g * (1.0f - v) + (float)second.g * v), (int)((float)first.b * (1.0f - v) + (float)second.b * v));
    }

    public static boolean isLoading() {
        class_6360.class_6363 state = ((ResourceReloadLoggerAccessor)((MinecraftClientAccessor)MeteorClient.mc).meteor$getResourceReloadLogger()).meteor$getReloadState();
        return state == null || !((ReloadStateAccessor)state).meteor$isFinished();
    }

    public static int parsePort(String full) {
        int port;
        if (full == null || full.isBlank() || !full.contains(":")) {
            return -1;
        }
        try {
            port = Integer.parseInt(full.substring(full.lastIndexOf(58) + 1, full.length() - 1));
        }
        catch (NumberFormatException ignored) {
            port = -1;
        }
        return port;
    }

    public static String parseAddress(String full) {
        if (full == null || full.isBlank() || !full.contains(":")) {
            return full;
        }
        return full.substring(0, full.lastIndexOf(58));
    }

    public static boolean resolveAddress(String address) {
        if (address == null || address.isBlank()) {
            return false;
        }
        int port = Utils.parsePort(address);
        if (port == -1) {
            port = 25565;
        } else {
            address = Utils.parseAddress(address);
        }
        return Utils.resolveAddress(address, port);
    }

    public static boolean resolveAddress(String address, int port) {
        if (port <= 0 || port > 65535 || address == null || address.isBlank()) {
            return false;
        }
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        return !socketAddress.isUnresolved();
    }

    public static Vector3d set(Vector3d vec, class_243 v) {
        vec.x = v.field_1352;
        vec.y = v.field_1351;
        vec.z = v.field_1350;
        return vec;
    }

    public static Vector3d set(Vector3d vec, class_1297 entity, double tickDelta) {
        vec.x = class_3532.method_16436((double)tickDelta, (double)entity.field_6038, (double)entity.method_23317());
        vec.y = class_3532.method_16436((double)tickDelta, (double)entity.field_5971, (double)entity.method_23318());
        vec.z = class_3532.method_16436((double)tickDelta, (double)entity.field_5989, (double)entity.method_23321());
        return vec;
    }

    public static boolean nameFilter(String text, char character) {
        return character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9' || character == '_' || character == '-' || character == '.' || character == ' ';
    }

    public static boolean ipFilter(String text, char character) {
        if (text.contains(":") && character == ':') {
            return false;
        }
        return character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9' || character == '.' || character == '-' || character == ':';
    }

    static {
        rendering3D = true;
        matrix = new class_11278("meteor-projection-matrix", -10.0f, 100.0f, true);
    }
}

