/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.schematic;

import baritone.api.schematic.AbstractSchematic;
import baritone.api.schematic.CompositeSchematicEntry;
import baritone.api.schematic.ISchematic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2680;

public class CompositeSchematic
extends AbstractSchematic {
    private final List<CompositeSchematicEntry> schematics = new ArrayList<CompositeSchematicEntry>();
    private CompositeSchematicEntry[] schematicArr;

    private void recalcArr() {
        CompositeSchematicEntry[] compositeSchematicEntryArray = this.schematicArr = this.schematics.toArray(new CompositeSchematicEntry[0]);
        int n = this.schematicArr.length;
        for (int i = 0; i < n; ++i) {
            CompositeSchematicEntry compositeSchematicEntry = compositeSchematicEntryArray[i];
            this.x = Math.max(this.x, compositeSchematicEntry.x + compositeSchematicEntry.schematic.widthX());
            this.y = Math.max(this.y, compositeSchematicEntry.y + compositeSchematicEntry.schematic.heightY());
            this.z = Math.max(this.z, compositeSchematicEntry.z + compositeSchematicEntry.schematic.lengthZ());
        }
    }

    public CompositeSchematic(int n, int n2, int n3) {
        super(n, n2, n3);
        this.recalcArr();
    }

    public void put(ISchematic iSchematic, int n, int n2, int n3) {
        this.schematics.add(new CompositeSchematicEntry(iSchematic, n, n2, n3));
        this.recalcArr();
    }

    private CompositeSchematicEntry getSchematic(int n, int n2, int n3, class_2680 class_26802) {
        CompositeSchematicEntry[] compositeSchematicEntryArray = this.schematicArr;
        int n4 = this.schematicArr.length;
        for (int i = 0; i < n4; ++i) {
            CompositeSchematicEntry compositeSchematicEntry = compositeSchematicEntryArray[i];
            if (n < compositeSchematicEntry.x || n2 < compositeSchematicEntry.y || n3 < compositeSchematicEntry.z || !compositeSchematicEntry.schematic.inSchematic(n - compositeSchematicEntry.x, n2 - compositeSchematicEntry.y, n3 - compositeSchematicEntry.z, class_26802)) continue;
            return compositeSchematicEntry;
        }
        return null;
    }

    @Override
    public boolean inSchematic(int n, int n2, int n3, class_2680 class_26802) {
        CompositeSchematicEntry compositeSchematicEntry = this.getSchematic(n, n2, n3, class_26802);
        return compositeSchematicEntry != null && compositeSchematicEntry.schematic.inSchematic(n - compositeSchematicEntry.x, n2 - compositeSchematicEntry.y, n3 - compositeSchematicEntry.z, class_26802);
    }

    @Override
    public class_2680 desiredState(int n, int n2, int n3, class_2680 class_26802, List<class_2680> list) {
        CompositeSchematicEntry compositeSchematicEntry = this.getSchematic(n, n2, n3, class_26802);
        if (compositeSchematicEntry == null) {
            throw new IllegalStateException("couldn't find schematic for this position");
        }
        return compositeSchematicEntry.schematic.desiredState(n - compositeSchematicEntry.x, n2 - compositeSchematicEntry.y, n3 - compositeSchematicEntry.z, class_26802, list);
    }

    @Override
    public void reset() {
        CompositeSchematicEntry[] compositeSchematicEntryArray = this.schematicArr;
        int n = this.schematicArr.length;
        for (int i = 0; i < n; ++i) {
            compositeSchematicEntryArray[i].schematic.reset();
        }
    }
}

