/*
 * Decompiled with CFR 0.152.
 */
package baritone.command.argparser;

import baritone.api.command.argparser.IArgParser;
import baritone.api.command.argument.ICommandArgument;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class DefaultArgParsers {
    public static final List<IArgParser<?>> a = Arrays.asList(IntArgumentParser.a, LongArgumentParser.a, FloatArgumentParser.a, DoubleArgumentParser.a, BooleanArgumentParser.a);

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class IntArgumentParser
    extends Enum<IntArgumentParser>
    implements IArgParser.Stateless<Integer> {
        public static final /* enum */ IntArgumentParser a = new IntArgumentParser("INSTANCE");
        private static final /* synthetic */ IntArgumentParser[] a;

        public static IntArgumentParser[] values() {
            return (IntArgumentParser[])a.clone();
        }

        public static IntArgumentParser valueOf(String string) {
            return Enum.valueOf(IntArgumentParser.class, string);
        }

        @Override
        public final Class<Integer> getTarget() {
            return Integer.class;
        }

        @Override
        public final /* synthetic */ Object parseArg(ICommandArgument iCommandArgument) {
            return Integer.parseInt(iCommandArgument.getValue());
        }

        static {
            a = new IntArgumentParser[]{a};
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class LongArgumentParser
    extends Enum<LongArgumentParser>
    implements IArgParser.Stateless<Long> {
        public static final /* enum */ LongArgumentParser a = new LongArgumentParser("INSTANCE");
        private static final /* synthetic */ LongArgumentParser[] a;

        public static LongArgumentParser[] values() {
            return (LongArgumentParser[])a.clone();
        }

        public static LongArgumentParser valueOf(String string) {
            return Enum.valueOf(LongArgumentParser.class, string);
        }

        @Override
        public final Class<Long> getTarget() {
            return Long.class;
        }

        @Override
        public final /* synthetic */ Object parseArg(ICommandArgument iCommandArgument) {
            return Long.parseLong(iCommandArgument.getValue());
        }

        static {
            a = new LongArgumentParser[]{a};
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class FloatArgumentParser
    extends Enum<FloatArgumentParser>
    implements IArgParser.Stateless<Float> {
        public static final /* enum */ FloatArgumentParser a = new FloatArgumentParser("INSTANCE");
        private static final /* synthetic */ FloatArgumentParser[] a;

        public static FloatArgumentParser[] values() {
            return (FloatArgumentParser[])a.clone();
        }

        public static FloatArgumentParser valueOf(String string) {
            return Enum.valueOf(FloatArgumentParser.class, string);
        }

        @Override
        public final Class<Float> getTarget() {
            return Float.class;
        }

        @Override
        public final /* synthetic */ Object parseArg(ICommandArgument object) {
            if (!((String)(object = object.getValue())).matches("^([+-]?(?:\\d+(?:\\.\\d*)?|\\.\\d+)|)$")) {
                throw new IllegalArgumentException("failed float format check");
            }
            return Float.valueOf(Float.parseFloat((String)object));
        }

        static {
            a = new FloatArgumentParser[]{a};
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static final class DoubleArgumentParser
    extends Enum<DoubleArgumentParser>
    implements IArgParser.Stateless<Double> {
        public static final /* enum */ DoubleArgumentParser a = new DoubleArgumentParser("INSTANCE");
        private static final /* synthetic */ DoubleArgumentParser[] a;

        public static DoubleArgumentParser[] values() {
            return (DoubleArgumentParser[])a.clone();
        }

        public static DoubleArgumentParser valueOf(String string) {
            return Enum.valueOf(DoubleArgumentParser.class, string);
        }

        @Override
        public final Class<Double> getTarget() {
            return Double.class;
        }

        @Override
        public final /* synthetic */ Object parseArg(ICommandArgument object) {
            if (!((String)(object = object.getValue())).matches("^([+-]?(?:\\d+(?:\\.\\d*)?|\\.\\d+)|)$")) {
                throw new IllegalArgumentException("failed double format check");
            }
            return Double.parseDouble((String)object);
        }

        static {
            a = new DoubleArgumentParser[]{a};
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public static class BooleanArgumentParser
    implements IArgParser.Stateless<Boolean> {
        public static final BooleanArgumentParser a = new BooleanArgumentParser();
        private static List<String> a;
        private static List<String> b;

        @Override
        public Class<Boolean> getTarget() {
            return Boolean.class;
        }

        @Override
        public /* synthetic */ Object parseArg(ICommandArgument object) {
            if (a.contains(((String)(object = object.getValue())).toLowerCase(Locale.US))) {
                return Boolean.TRUE;
            }
            if (b.contains(((String)object).toLowerCase(Locale.US))) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("invalid boolean");
        }

        static {
            a = Arrays.asList("1", "true", "yes", "t", "y", "on", "enable");
            b = Arrays.asList("0", "false", "no", "f", "n", "off", "disable");
        }
    }
}

