/*
 * Decompiled with CFR 0.152.
 */
package baritone.api.command.datatypes;

import baritone.api.command.datatypes.IDatatypeContext;
import baritone.api.command.datatypes.IDatatypePost;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public enum RelativeCoordinate implements IDatatypePost<Double, Double>
{
    INSTANCE;

    private static String ScalesAliasRegex;
    private static Pattern PATTERN;

    @Override
    public final Double apply(IDatatypeContext object, Double d) {
        double d2;
        if (d == null) {
            d = 0.0;
        }
        if (!((Matcher)(object = PATTERN.matcher(object.getConsumer().getString()))).matches()) {
            throw new IllegalArgumentException("pattern doesn't match");
        }
        boolean bl = !((Matcher)object).group(1).isEmpty();
        double d3 = d2 = ((Matcher)object).group(2).isEmpty() ? 0.0 : Double.parseDouble(((Matcher)object).group(2).replaceAll(ScalesAliasRegex, ""));
        if (((Matcher)object).group(2).toLowerCase().contains("k")) {
            d2 *= 1000.0;
        }
        if (((Matcher)object).group(2).toLowerCase().contains("m")) {
            d2 *= 1000000.0;
        }
        if (bl) {
            return d + d2;
        }
        return d2;
    }

    @Override
    public final Stream<String> tabComplete(IDatatypeContext object) {
        if (!(object = object.getConsumer()).has(2) && object.getString().matches("^(~|$)")) {
            return Stream.of("~");
        }
        return Stream.empty();
    }

    static {
        ScalesAliasRegex = "[kKmM]";
        PATTERN = Pattern.compile("^(~?)([+-]?(?:\\d+(?:\\.\\d*)?|\\.\\d+)(" + "[kKmM]" + "?)|)$");
    }
}

