/*
 * Decompiled with CFR 0.152.
 */
package baritone.command.defaults;

import baritone.Baritone;
import baritone.api.cache.IWaypoint;
import baritone.api.command.Command;
import baritone.api.command.argument.IArgConsumer;
import baritone.api.command.datatypes.ForWaypoints;
import baritone.api.command.exception.CommandInvalidStateException;
import baritone.api.utils.BetterBlockPos;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class FarmCommand
extends Command {
    public FarmCommand(Baritone baritone) {
        super(baritone, "farm");
    }

    @Override
    public void execute(String string, IArgConsumer object) {
        object.requireMax(2);
        int n = 0;
        BetterBlockPos betterBlockPos = null;
        if (object.has(1)) {
            n = object.getAs(Integer.class);
        }
        if (object.has(1)) {
            object = (IWaypoint[])object.getDatatypeFor(ForWaypoints.INSTANCE);
            switch (((IWaypoint[])object).length) {
                case 0: {
                    throw new CommandInvalidStateException("No waypoints found");
                }
                case 1: {
                    object = object[0];
                    break;
                }
                default: {
                    throw new CommandInvalidStateException("Multiple waypoints were found");
                }
            }
            betterBlockPos = object.getLocation();
        }
        this.baritone.getFarmProcess().farm(n, betterBlockPos);
        this.logDirect("Farming");
    }

    @Override
    public Stream<String> tabComplete(String string, IArgConsumer iArgConsumer) {
        return Stream.empty();
    }

    @Override
    public String getShortDesc() {
        return "Farm nearby crops";
    }

    @Override
    public List<String> getLongDesc() {
        return Arrays.asList("The farm command starts farming nearby plants. It harvests mature crops and plants new ones.", "", "Usage:", "> farm - farms every crop it can find.", "> farm <range> - farm crops within range from the starting position.", "> farm <range> <waypoint> - farm crops within range from waypoint.");
    }
}

